@extends('app.layout.app')

@section('header_content')
    <style>
        :root{
            --green:#1f8b4c;
            --white:#ffffff;
        }
        /* থিম: সাদা + সবুজ */
        .wrapper-inline{ background-color:#ecf8f0; } /* হালকা সবুজ আভা */
        header.no-background{ background-color:#ecf8f0 !important; }
        h3.logo{ color:var(--green); font-size:16px; font-weight:600; letter-spacing:2px; margin:0; margin-top:5px; }

        .search-button,.navi-menu-button{ width:unset; }

        /* স্লাইডার (আগের মতো, কেবল ছায়া/রঙ নরম) */
        .second_slider_item{ width:320px; margin-left:72px; box-shadow:0 5px 10px #0000; padding:5px 2px; }
        .owl-item.cloned{ width:300px !important; }
        .second_slider_container .owl-carousel .owl-stage-outer{ height:170px !important; }
        .owl-carousel .owl-item img{ display:block; width:300px; height:150px; }

        footer{ margin-bottom:0; }

        /* কার্ড/টেবিল রঙ */
        .header_box_card{ background:#fff; border:1px solid #e8f1ec; }
        .header_box h4{ color:#0f5132; }          /* গাঢ় সবুজ */
        .my-balance{ color:#0f5132; }
        .vip_card{ border:1px solid #e8f1ec; }
        .vip_title_hiro{ color:#0f5132; }

        /* ব্যাজগুলোকে সবুজ/সাদা থিমে আনা */
        .badge{ border-radius:999px; padding:.35rem .7rem; font-weight:700; letter-spacing:.2px; }
        .badge-success{ background:var(--green); color:var(--white); }
        .badge-warning{ background:#e6f4ea; color:#0f5132; border:1px solid #bfe0c9; }
        .badge-danger{ background:#fff; color:#c81e1e; border:1px solid #f3caca; }

        /* চেকার (স্ট্যাটাস সুইচ) */
        .fa_checker label{ border:1px solid #bfe0c9; }
        .fa_checker .effect-one:checked + label{ background:var(--green) !important; border-color:var(--green); }

        /* টেবিল */
        .table td,.table th{ padding:4px 10px; vertical-align:top; border-top:1px solid #e9ecef; font-size:15px; }
        .table-bordered{ border-color:#e8f1ec; }
        .table-bordered td,.table-bordered th{ border-color:#e8f1ec; }
        .table td:first-child{ color:#374151; font-weight:700; }
        .small,small{ font-size:11px; }
    </style>
@endsection

@section('app_content')
    <section class="badger">
        <div class="container">
            <div class="card header_box_card">
                <div class="card-body header_box">
                    <div class="row">
                        <div class="col-5">
                            <h3 class="my-balance" style="margin-top:12px">
                                {{ auth()->user()->balance }}
                                <small>USDT</small>
                            </h3>
                        </div>
                        <div class="col-7">
                            <h4 style="font-size:15px">
                                {{ __('আপনার সকল উত্তোলনের রেকর্ড') }}
                            </h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="vip_cards_box">
        <div class="container">
            @foreach($withdraws as $withdraw)
                <div class="card vip_card">
                    <div class="card-body vip_card_body">
                        <div class="row mt-2">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <div><h2 class="vip_title_hiro">{{ __('উত্তোলন বিস্তারিত') }}</h2></div>
                                    <div class="fa_checker">
                                        <input id="check-one-{{ $withdraw->id }}" class="effect-one" type="checkbox" @if($withdraw->status=='approved') checked @endif>
                                        <label for="check-one-{{ $withdraw->id }}" @if($withdraw->status=='pending') style="background:#e6f4ea" @endif>
                                            <span class="inner"></span>
                                            <span class="icon"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row"><div class="col-12">
                            <table class="table table-bordered">
                                <tr>
                                    <td>{{ __('উত্তোলন পদ্ধতি') }}</td>
                                    <td>{{ $withdraw->payment_method->name }}</td>
                                </tr>
                                <tr>
                                    <td>{{ __('উত্তোলনের পরিমাণ') }}</td>
                                    <td>{{ $withdraw->amount }}<small> USDT</small></td>
                                </tr>
                                <tr>
                                    <td>{{ __('উত্তোলন চার্জ') }}</td>
                                    <td>{{ $withdraw->charge }}<small> USDT</small></td>
                                </tr>
                                <tr>
                                    <td>{{ __('চূড়ান্ত পরিমাণ') }}</td>
                                    <td>{{ $withdraw->final_amount * setting('rate') }}<small> BDT</small></td>
                                </tr>

                                @if($withdraw->status == 'approved')
                                    <tr>
                                        <td>{{ __('ট্রান্স্যাকশন আইডি') }}</td>
                                        <td>{{ $withdraw->trx ?? '--' }}</td>
                                    </tr>
                                @endif

                                <tr>
                                    <td>{{ __('মুদ্রা') }}</td>
                                    <td>{{ $withdraw->currency }}</td>
                                </tr>
                                <tr>
                                    <td>{{ __('তারিখ ও সময়') }}</td>
                                    <td>{{ $withdraw->created_at }}</td>
                                </tr>
                                <tr>
                                    <td>{{ __('অবস্থা') }}</td>
                                    <td>
                                        @if($withdraw->status == 'approved')
                                            <div class="badge badge-success">{{ __('অনুমোদিত') }}</div>
                                        @elseif($withdraw->status == 'pending')
                                            <div class="badge badge-warning">{{ __('মুলতুবি') }}</div>
                                        @elseif($withdraw->status == 'rejected')
                                            <div class="badge badge-danger">{{ __('বাতিল') }}</div>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div></div>
                    </div>
                </div>
            @endforeach
        </div>
    </section>
    <footer></footer>
@endsection
