<html lang="bn">
<head>
  @include('app.layout.css')
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>উত্তোলন</title>

  <!-- আপনার প্রজেক্টের CSS -->
  <link rel="stylesheet" href="{{asset('public/bp/main.css')}}">
  <link rel="stylesheet" href="{{asset('public/bp/withdraw.css')}}">
  <link rel="stylesheet" href="{{asset('public/bp/loading.css')}}">

  <!-- আইকন/ফন্ট -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    :root{
      --green:#1f8b4c;
      --orange:#f4511e;
      --muted:#6b7280;
      --line:#ececec;
      --bg:#f7f7f7;
      --card:#ffffff;
      --ink:#111827;
    }
    *{box-sizing:border-box}
    body{ background:var(--bg); margin:0; color:var(--ink); font-family:Inter, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Noto Sans", sans-serif; }
    .page-wrap{ padding-bottom:92px; }

    /* ===== Header (clean, sticky) ===== */
    .headerid{ position:sticky; top:0; z-index:5; background:#fff; padding:12px; border-bottom:1px solid var(--line); }
    .headergrid{ display:grid; grid-template-columns:40px 1fr 40px; align-items:center; }
    .headergrid .title{ text-align:center; font-weight:800; }

    /* ===== Card primitives ===== */
    .container{ padding:12px; }
    .card{ background:var(--card); border:1px solid var(--line); border-radius:16px; box-shadow:0 1px 0 rgba(0,0,0,.02); }
    .pad{ padding:14px; }
    .row{ display:flex; align-items:center; gap:10px; }

    /* ===== Balance: gradient badge style ===== */
    .balance-wrap{ position:relative; overflow:hidden; }
    .balance-grad{
      position:absolute; inset:-1px; background:linear-gradient(135deg,#e8f5ec 0%, #ffffff 35%, #e8f5ec 100%);
      z-index:0;
    }
    .balance{ position:relative; z-index:1; display:flex; justify-content:space-between; align-items:center; }
    .bal-left{ display:flex; align-items:center; gap:10px; }
    .bal-ico{ width:34px; height:34px; border-radius:10px; background:#f3f6f4; border:1px solid #e2ebe6; display:flex; align-items:center; justify-content:center; }
    .bal-ico img{ width:20px; height:20px; object-fit:contain; }
    .bal-label{ font-weight:800; color:#1e293b; }
    .bal-amt{ font-size:22px; font-weight:900; color:var(--green); margin-top:6px; line-height:1; }
    .bal-badge{ background:#e8f5ee; border:1px solid rgba(31,139,76,.4); color:var(--green); padding:6px 10px; border-radius:999px; font-weight:800; font-size:12px; }

    /* ===== Info list ===== */
    .infolist{ display:grid; gap:10px; margin-top:12px; }
    .infoitem{ display:flex; gap:10px; align-items:flex-start; background:#fff; border:1px dashed #e6e9ee; border-radius:12px; padding:10px 12px; }
    .infoitem .dot{ width:18px; height:18px; border-radius:999px; border:2px solid var(--green); display:flex; align-items:center; justify-content:center; }
    .infoitem .dot::after{ content:""; width:10px; height:10px; background:var(--green); border-radius:999px; }
    .infoitem p{ margin:0; font-weight:700; color:#0f172a; }

    /* ===== Withdraw form (unique input + chips) ===== */
    .wform{ margin-top:12px; }
    .amtbox{ display:flex; align-items:center; gap:10px; background:#fff; border:1px solid var(--line); border-radius:14px; padding:12px; }
    .amt-prefix{ background:#e8f5ee; color:var(--green); border:1px solid rgba(31,139,76,.4); font-weight:900; padding:8px 12px; border-radius:10px; }
    .amt-col{ flex:1; }
    .amt-col label{ display:block; font-weight:800; color:#334155; margin-bottom:6px; }
    .amt-input{ width:100%; height:42px; border:1px solid #e5e7eb; border-radius:10px; padding:0 12px; outline:0; font-weight:800; }
    .chips{ display:flex; flex-wrap:wrap; gap:8px; margin-top:10px; }
    .chip{ border:1px solid #e5e7eb; background:#fff; padding:8px 12px; border-radius:999px; font-weight:800; cursor:pointer; transition:transform .06s ease, box-shadow .2s ease, border-color .15s ease; }
    .chip:hover{ transform:translateY(-1px); box-shadow:0 8px 18px rgba(0,0,0,.06); }
    .chip.active{ border-color:var(--green); box-shadow:0 8px 18px rgba(31,139,76,.14); }

    .submit-btn{ width:100%; border:none; border-radius:12px; padding:12px; background:var(--green); color:#fff; font-weight:900; margin-top:12px; cursor:pointer; }

    /* ===== Records (status badges) ===== */
    .section-title{ background:#eef2f7; color:#111827; padding:10px 12px; border-radius:10px; font-weight:800; margin:16px 0 8px; }
    .rec{ display:flex; justify-content:space-between; align-items:center; background:#fff; border:1px solid var(--line); border-radius:14px; padding:12px; margin-bottom:10px; }
    .rec-amt{ font-weight:900; color:#0f172a; }
    .rec-time{ font-size:12px; color:#64748b; margin-top:2px; }
    .badge{ font-weight:800; padding:6px 10px; border-radius:999px; display:inline-flex; align-items:center; gap:6px; border:1px solid transparent; }
    .badge.success{ color:#16a34a; background:#ecfdf5; border-color:#a7f3d0; }
    .badge.cancel{ color:#ef4444; background:#fef2f2; border-color:#fecaca; }
    .badge.proc{ color:#b45309; background:#fff7ed; border-color:#fed7aa; }
    .badge i{ font-size:14px; }

    /* ===== Bottom tabbar ===== */
    .tabbar{ position:fixed; left:0; right:0; bottom:0; background:#ffffff; border-top:1px solid var(--line); padding:8px 6px; z-index:999; }
    .tabs{ display:grid; grid-template-columns:repeat(5,1fr); gap:4px; text-align:center; }
    .tab a{ display:flex; flex-direction:column; gap:4px; align-items:center; font-size:12px; color:#64748b; text-decoration:none; }
    .tab .ico{ width:26px; height:26px; display:flex; align-items:center; justify-content:center; }
    .tab .ico img{ width:100%; height:100%; object-fit:contain; filter:saturate(1) contrast(1.05); }
    .tab.active a{ color:var(--green); font-weight:800; }
    .tab.active .ico img{ filter:saturate(1.2) contrast(1.1); }
    .tab a:active{ transform:translateY(1px); }
  </style>
</head>
<body>
@include('app.layout.loading')

<div class="page-wrap">
  <!-- Header -->
  <div class="headerid">
    <div class="headergrid">
      <div class="row" onclick="history.back()" style="cursor:pointer"><img src="{{asset('public/bp/img/back.png')}}" alt="" style="width:22px;height:22px"></div>
      <div class="title">উত্তোলন</div>
      <div class="row" style="justify-content:flex-end; gap:10px">
        <a href="{{\App\Models\Setting::first()->telegram}}"><img src="{{asset('public/bp/img/kf.png')}}" alt="" style="width:22px;height:22px"></a>
        <a href="{{\App\Models\Setting::first()->telegram}}"><img src="{{asset('public/bp/img/share.png')}}" alt="" style="width:22px;height:22px"></a>
      </div>
    </div>
  </div>

  <input type="hidden" id="TOKEN" value="d51b00b229573f4242a023404b14727b">

  <div class="container">
    <!-- Balance card -->
    <div class="card balance-wrap">
      <div class="balance-grad"></div>
      <div class="pad balance">
        <div>
          <div class="bal-left">
            <div class="bal-ico"><img src="{{asset('public/bp/img/balance.png')}}" alt=""></div>
            <div class="bal-label">ব্যালেন্স</div>
          </div>
          <div class="bal-amt">৳ {{ preg_replace('/[^\d\.,-]/','', price(\auth()->user()->income)) }}</div>
        </div>
        <div class="bal-badge">তাৎক্ষণিক প্রসেস</div>
      </div>
    </div>

    <!-- Info notes -->
    <div class="infolist">
      <div class="infoitem">
        <div class="dot"></div>
        <p>প্রসেসিং সময়: ২৪×৭</p>
      </div>
      <div class="infoitem">
        <div class="dot"></div>
        <p>ন্যূনতম উত্তোলন: <b>৳ {{ preg_replace('/[^\d\.,-]/','', price(setting('minimum_withdraw'))) }}</b></p>
      </div>
      <div class="infoitem">
        <div class="dot"></div>
        <p>ফি: <b>{{ setting('withdraw_charge') }}%</b></p>
      </div>
    </div>

    <!-- Withdraw form -->
    <form action="{{ route('user.withdraw.request') }}" method="post" class="wform">@csrf
      <div class="amtbox">
        <div class="amt-prefix">৳</div>
        <div class="amt-col">
          <label for="amountInput">উত্তোলনের পরিমাণ</label>
          <input id="amountInput" type="number" class="amt-input check_number_func amount_input" name="amount" placeholder="যেমন: ৫০০০" required>
        </div>
      </div>

      <!-- Quick chips -->
      <div class="chips" id="amountChips">
        <button type="button" class="chip" data-amt="2000">৳ ২,০০০</button>
        <button type="button" class="chip" data-amt="5000">৳ ৫,০০০</button>
        <button type="button" class="chip" data-amt="10000">৳ ১০,০০০</button>
        <button type="button" class="chip" data-amt="20000">৳ ২০,০০০</button>
      </div>

      <button type="submit" class="submit-btn">উত্তোলন করুন</button>
    </form>

    <!-- Records -->
    <div class="section-title">উত্তোলন রেকর্ড</div>
    @foreach(\App\Models\Withdrawal::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
      <div class="rec">
        <div>
          <div class="rec-amt">৳ {{ preg_replace('/[^\d\.,-]/','', price($element->final_amount)) }}</div>
          <div class="rec-time">{{ $element->created_at }}</div>
        </div>
        <div>
          @if($element->status=='approved')
            <span class="badge success"><i class="fa-solid fa-check-circle"></i> সফল</span>
          @elseif($element->status=='rejected')
            <span class="badge cancel"><i class="fa-solid fa-xmark-circle"></i> বাতিল</span>
          @else
            <span class="badge proc"><i class="fa-solid fa-hourglass-half"></i> প্রক্রিয়াধীন</span>
          @endif
        </div>
      </div>
    @endforeach
    <p class="text-center" style="color:#6b7280; margin:6px 0 0;">— শেষ —</p>
  </div>
</div>

@include('app.layout.manu')
@include('alert-message')

<!-- Bottom Tabbar -->
<nav class="tabbar">
  <div class="tabs">
    <div class="tab" data-tab="home">
      <a href="{{ \Illuminate\Support\Facades\Route::has('user.home') ? route('user.home') : url('/') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/home.png') }}" alt="হোম" onerror="this.src='{{asset('public/bp/img/logo.png')}}'"></div>
        <span>হোম</span>
      </a>
    </div>
    <div class="tab" data-tab="products">
      <a href="{{ \Illuminate\Support\Facades\Route::has('user.products') ? route('user.products') : ( \Illuminate\Support\Facades\Route::has('user.home') ? route('user.home').'#productsSection' : url('/#productsSection') ) }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/products.png') }}" alt="পণ্য" onerror="this.src='{{asset('public/bp/img/logo.png')}}'"></div>
        <span>পণ্য</span>
      </a>
    </div>
    <div class="tab" data-tab="spin">
      <a href="{{ \Illuminate\Support\Facades\Route::has('user.games') ? route('user.games') : url('spin') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/game.png') }}" alt="খেলা" onerror="this.src='{{asset('public/bp/img/logo.png')}}'"></div>
        <span>খেলা</span>
      </a>
    </div>
    <div class="tab" data-tab="invite">
      <a href="{{ \Illuminate\Support\Facades\Route::has('user.invite') ? route('user.invite') : url('invite') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/share.png') }}" alt="শেয়ার" onerror="this.src='{{asset('public/bp/img/logo.png')}}'"></div>
        <span>শেয়ার</span>
      </a>
    </div>
    <div class="tab" data-tab="mine">
      <a href="{{ \Illuminate\Support\Facades\Route::has('user.profile') ? route('user.profile') : url('mine') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/me.png') }}" alt="আমার" onerror="this.src='{{asset('public/bp/img/logo.png')}}'"></div>
        <span>আমার</span>
      </a>
    </div>
  </div>
</nav>

<script>
  // Quick chips -> fill amount
  (function(){
    const chips = document.getElementById('amountChips');
    const input = document.getElementById('amountInput');
    if(chips && input){
      chips.addEventListener('click', (e)=>{
        const btn = e.target.closest('.chip'); if(!btn) return;
        chips.querySelectorAll('.chip').forEach(c=>c.classList.remove('active'));
        btn.classList.add('active');
        input.value = btn.getAttribute('data-amt') || '';
        input.focus();
      });
    }
  })();

  // Tabbar active highlight (keep 'mine' default if no match)
  (function(){
    function norm(url){ const a=document.createElement('a'); a.href=url; return {path:(a.pathname.replace(/\/+$/,'')||'/'), hash:a.hash||''}; }
    const here=norm(location.href); const tabs=[...document.querySelectorAll('.tabbar .tab')];
    tabs.forEach(t=>t.classList.remove('active'));
    let matched=false;
    document.querySelectorAll('.tabbar .tab a').forEach(a=>{
      const dest=norm(a.href);
      const isProducts = a.closest('.tab')?.dataset.tab==='products';
      const homePath   = norm("{{ \Illuminate\Support\Facades\Route::has('user.home') ? route('user.home') : url('/') }}").path;
      if(isProducts && here.path===homePath && here.hash==='#productsSection'){ a.closest('.tab').classList.add('active'); matched=true; return; }
      if(dest.path===here.path){ a.closest('.tab').classList.add('active'); matched=true; }
    });
    if(!matched){ const mine=document.querySelector('.tabbar .tab[data-tab="mine"]'); if(mine){ mine.classList.add('active'); } }
  })();
</script>
</body>
</html>
