<!DOCTYPE html>
<html lang="en">
<head>
    @include('app.layout.css')
</head>
<body>
@include('app.layout.loading')
<style>
    .client-price p {
        color: #17cdaf !important;
    }
    .wrapper {
        background: #0000000f;
    }
    .alert-box {
        background: #ffe9e9;
        border: 1px solid #f5bcbc;
        color: #b30000;
        padding: 10px 15px;
        border-radius: 8px;
        margin-bottom: 10px;
        text-align: center;
        font-weight: 500;
    }
</style>

<div class="wrapper home-page">

    <div style="height: 200px;position: relative;background: url('{{asset('v_banner.jpeg')}}');background-size: cover;">
        <div style="display: flex;justify-content: space-between;padding: 15px;">
            <div style="color: #fff;font-size: 18px;" onclick="window.location.href='{{route('dashboard')}}'"><i class="fa fa-chevron-left"></i></div>
            <div style="color: #fff;font-size: 22px;text-shadow: 3px 1px black;">VIP Details</div>
            <div></div>
        </div>

        <div style="height: 340px;">
            <div class="ssdsdsd">
                <h3 style="text-transform: uppercase;font-size: 25px;font-weight: normal">{{$vip->title}}</h3>
                <div style="margin-top: 50px;display: flex;justify-content: space-between;">
                    <div>
                        <div>Initial investment price:</div>
                        <div style="margin-top: 10px;color: red">{{price($vip->price)}}</div>
                        <div style="margin-top: 20px;">Cycle: {{$vip->validity}} day</div>
                    </div>
                    <div>
                        <div>Project size:</div>
                        <div style="margin-top: 10px;">{{price($vip->commission_with_avg_amount)}}</div>
                        <div style="margin-top: 20px;">Daily dividend</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="ssdsdsd sded" style="position: unset;top: unset;margin: auto;transform: unset;padding-bottom: 100px;">

            {{-- ✅ Referral Requirement Alert --}}
            @if($vip->referral_enabled)
                @php
                    $referralCount = \App\Models\User::where('ref_by', auth()->user()->ref_id)->count();
                @endphp

                @if($referralCount < $vip->referral_required)
                    <div class="alert-box">
                        🔒 You need at least <strong>{{$vip->referral_required}}</strong> active referrals to unlock this plan.<br>
                        You currently have <strong>{{$referralCount}}</strong>.
                    </div>
                @else
                    <div class="alert-box" style="background: #e8fff2; border-color: #b4f0c4; color: #0a7a29;">
                        ✅ Your referral requirement is fulfilled! You can purchase this plan.
                    </div>
                @endif
            @endif
            {{-- ✅ End Alert --}}

            <h3 style="text-transform: uppercase;font-size: 18px;font-weight: normal;text-align: center;position:relative;">project introduction</h3>
            <div>
                <h2 style="font-weight: normal;margin-top: 25px;">Description</h2>
                <p style="font-size: 18px;margin-top: 12px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
            </div>

            {{-- ✅ যদি শর্ত পূরণ না হয় তবে বাটন disable হবে --}}
            <div>
                @if($vip->referral_enabled && $referralCount < $vip->referral_required)
                    <a href="javascript:void(0)" style="padding: 8px 0; opacity: 0.6; pointer-events: none; background: #999;" class="subscript_btn">Locked</a>
                @else
                    <a href="javascript:void(0)" onclick="openPurchaseModal()" style="padding: 8px 0;" class="subscript_btn">Subscribe now</a>
                @endif
            </div>
        </div>
    </div>


    {{-- purchase modal unchanged --}}
    <div class="purchase_box" style="opacity: 0;z-index: -1;transition: .4s;">
        <div class="purchase_container">
            <div class="closet" onclick="closePurchaseModal()"><i class="fa fa-close"></i></div>
            <div style="display: flex;">
                <div>
                    <img style="width: 60px;" src="{{asset(view_image($vip->photo))}}">
                </div>
                <div><h3 style="margin-top: 7px;">{{$vip->title}}</h3></div>
            </div>

            <div style="width: 70%;margin-left: auto;margin-top: 10px">
                <div style="display: flex;justify-content: space-between;">
                    <div style="color: #00000075">Price</div>
                    <div style="color: red;" id="price">{{price($vip->price)}}</div>
                </div>
                <div style="display: flex;justify-content: space-between;margin-top: 10px;">
                    <div style="color: #00000075">Income</div>
                    <div style="font-weight: 600;color: #000;" id="24Comission">{{price($vip->commission_with_avg_amount / $vip->validity)}}</div>
                </div>
                <div style="display: flex;justify-content: space-between;margin-top: 10px;">
                    <div style="color: #00000075">Time Cycle</div>
                    <div style="font-weight: 600;color: #000;">24 Hour</div>
                </div>
            </div>

            <div style="margin-top: 25px;">
                <div style="margin:auto;width: 200px;">
                    <div style="display: flex;justify-content: space-between">
                        <div class="inDec" id="minus">-</div>
                        <div class="qty_input"><input id="qty" type="text" value="1" style="font-size: 20px;padding-left: 10px"></div>
                        <div class="inDec" id="plus">+</div>
                    </div>
                </div>
            </div>

            <div>
                <button
                    class="subscript_btn"
                    id="con_btn"
                    style="border: none;font-size: 16px;width: 100%;border-top-left-radius: unset;margin-top:8px;"
                    type="button"
                    onclick="submit_purchase()"
                >Purchase Confirm</button>
            </div>
        </div>
    </div>

    <meta name="csrf-token" content="{{csrf_token()}}">
    <input type="hidden" name="id" value="{{$vip->id}}">
    <input type="hidden" name="final_price">
    <input type="hidden" name="final_commission">
    <input type="hidden" name="qty">

    {{-- JS অংশ অপরিবর্তিত --}}
    <script>
        var price = '<?= $vip->price; ?>';
        var amount24 = '<?= $vip->commission_with_avg_amount / $vip->validity ?>';
        ...
        // (তোমার আগের JS ঠিক 그대로 থাকবে)
    </script>

    @include('app.layout.manu')
</div>

<meta name="csrf-token" content="{{csrf_token()}}">
<script src="{{asset('assets/toast.js')}}"></script>
@include('alert-message')
@include('app.layout.js')
</body>
</html>
