<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>রেফারেল আয়</title>

  <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/team.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

  <style>
    :root{
      --green:#1f8b4c; --ink:#0f172a; --muted:#64748b;
      --card:#ffffff; --bg:#f7f7f7; --line:#ececec; --chip:#e8f5ee;
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif}
    .page-wrap{padding-bottom:90px}

    /* ===== Header (sticky) ===== */
    .headerid{position:sticky;top:0;z-index:5;background:#fff;border-bottom:1px solid var(--line)}
    .headergrid{display:grid;grid-template-columns:1fr 40px 40px;align-items:center;padding:10px 12px}
    .h-left{display:flex;align-items:center;gap:10px}
    .h-left img{width:22px;height:22px}
    .h-left div{font-weight:900}
    .h-right a{display:flex;align-items:center;justify-content:center}
    .h-right img{width:22px;height:22px}

    /* ===== Top summary ===== */
    .summary{padding:12px}
    .sum-row{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    .sum-card{background:linear-gradient(135deg,#e8f5ee,#ffffff);border:1px solid #dbe9e1;border-radius:16px;padding:12px}
    .sum-card span{display:block;color:#334155;font-weight:800;font-size:12px}
    .sum-card p{margin:6px 0 0;font-weight:900;font-size:20px}

    /* ===== Info note ===== */
    .obtain{background:#fff;border:1px solid var(--line);border-radius:14px;padding:12px;margin:0 12px}
    .obtain .flex_sta{display:flex;align-items:center;gap:8px}
    .obtain .flex_sta img{width:16px;height:16px}
    .obtain p{margin:0;color:#111}
    .obtain b{color:var(--green)}

    /* ===== Level cards ===== */
    .levels{padding:12px}
    .level-card{background:#fff;border:1px solid var(--line);border-radius:16px;margin-bottom:12px;overflow:hidden}
    .level-head{display:flex;align-items:center;justify-content:space-between;padding:12px;border-bottom:1px solid var(--line)}
    .level-head h6{margin:0;font-weight:900}
    .level-head a{display:flex;align-items:center;gap:6px;color:var(--green);font-weight:900;text-decoration:none}
    .level-head a img{width:14px;height:14px}

    .table{width:100%;border-collapse:separate;border-spacing:0 8px;padding:12px}
    .table .thead{display:grid;grid-template-columns:110px 1fr 1fr 1fr;color:#64748b;font-weight:800;font-size:12px;padding:0 6px}
    .table .row{display:grid;grid-template-columns:110px 1fr 1fr 1fr;gap:8px;background:#f8faf8;border:1px solid #e6efe8;border-radius:12px;padding:10px 8px;align-items:center}
    .table .row + .row{margin-top:8px}
    .tag{display:inline-block;background:var(--chip);color:var(--green);border:1px solid rgba(31,139,76,.35);border-radius:999px;padding:2px 8px;font-size:12px;font-weight:900}

    .empty{padding:20px;text-align:center;color:#94a3b8;font-weight:800}

    /* bottom spacing for menu include */
    .spacer{height:20px}
  </style>
</head>
<body>
<div class="page-wrap">
  <div class="centeritem">
    <div class="headerid">
      <div class="headergrid">
        <div class="h-left">
          <img src="{{ asset('public/bp/img/back.png') }}" alt="">
          <div>রেফারেল আয়</div>
        </div>
        <div class="h-right" style="display:flex;gap:6px">
          <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সহায়তা"></a>
          <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
        </div>
      </div>
    </div>
  </div>

  @php
    // কমিশন রেট (ডাটাবেজে একাধিক সারি থাকলে max ব্যবহার; না থাকলে 0)
    $first_ref  = \App\Models\Setting::max('first_refer_commission')  ?? 0;
    $second_ref = \App\Models\Setting::max('second_refer_commission') ?? 0;
    $third_ref  = \App\Models\Setting::max('third_refer_commission')  ?? 0;

    // BDT ফরম্যাটার: $ -> ৳
    $bdt = fn($v)=> str_replace('$','৳', price($v));
  @endphp

  <!-- Summary -->
  <div class="summary">
    <div class="sum-row">
      <div class="sum-card">
        <span>মোট জমা</span>
        <p>{{ $bdt($lvTotalDeposit) }}</p>
      </div>
      <div class="sum-card">
        <span>মোট উত্তোলন</span>
        <p>{{ $bdt($lvTotalWithdraw) }}</p>
      </div>
    </div>
  </div>

  <!-- Info note -->
  <div class="obtain">
    <div class="flex_sta">
      <img src="{{ asset('public/bp/img/point.png') }}" alt="">
      <p>
        আপনি লেভেল ১ রেফারালের জমার <b>{{ rtrim(rtrim(number_format($first_ref,2), '0'), '.') }}%</b>,
        লেভেল ২ রেফারালের <b>{{ rtrim(rtrim(number_format($second_ref,2), '0'), '.') }}%</b> এবং
        লেভেল ৩ রেফারালের <b>{{ rtrim(rtrim(number_format($third_ref,2), '0'), '.') }}%</b> কমিশন পাবেন।
      </p>
    </div>
  </div>

  <!-- Levels -->
  <div class="levels">
    <!-- Level 01 -->
    <div class="level-card">
      <div class="level-head">
        <h6>স্তর–০১</h6>
        <a class="flex_sta" href="{{ route('users.details','1') }}">
          {{ rtrim(rtrim(number_format($first_ref,2), '0'), '.') }}% <img src="{{ asset('public/bp/img/more2.png') }}" alt="">
        </a>
      </div>
      <div class="table">
        <div class="thead">
          <div></div>
          <div>রেফারেল (ব্যবহারকারী)</div>
          <div>জমা</div>
          <div>উত্তোলন</div>
        </div>

        <div class="row">
          <div>আজ</div>
          <div>
            <span class="tag">{{ $first_level_users->count() }}</span>
          </div>
          <div class="today_money_number">{{ $bdt($lv1Recharge) }}</div>
          <div class="today_income_number">{{ $bdt($lv1Withdraw) }}</div>
        </div>

        <div class="row">
          <div>মোট</div>
          <div>
            <span class="tag">{{ $first_level_users->count() }}</span>
          </div>
          <div class="total_money_number">{{ $bdt($lv1Recharge) }}</div>
          <div class="total_income_number">{{ $bdt($lv1Withdraw) }}</div>
        </div>
      </div>
    </div>

    <!-- Level 02 -->
    <div class="level-card">
      <div class="level-head">
        <h6>স্তর–০২</h6>
        <a class="flex_sta" href="{{ route('users.details','2') }}">
          {{ rtrim(rtrim(number_format($second_ref,2), '0'), '.') }}% <img src="{{ asset('public/bp/img/more2.png') }}" alt="">
        </a>
      </div>
      <div class="table">
        <div class="thead">
          <div></div>
          <div>রেফারেল (ব্যবহারকারী)</div>
          <div>জমা</div>
          <div>উত্তোলন</div>
        </div>

        <div class="row">
          <div>আজ</div>
          <div>
            <span class="tag">{{ $second_level_users->count() }}</span>
          </div>
          <div class="today_money_number">{{ $bdt($lv2Recharge) }}</div>
          <div class="today_income_number">{{ $bdt($lv2Withdraw) }}</div>
        </div>

        <div class="row">
          <div>মোট</div>
          <div>
            <span class="tag">{{ $second_level_users->count() }}</span>
          </div>
          <div class="total_money_number">{{ $bdt($lv2Recharge) }}</div>
          <div class="total_income_number">{{ $bdt($lv2Withdraw) }}</div>
        </div>
      </div>
    </div>

    <!-- Level 03 -->
    <div class="level-card">
      <div class="level-head">
        <h6>স্তর–০৩</h6>
        <a class="flex_sta" href="{{ route('users.details','3') }}">
          {{ rtrim(rtrim(number_format($third_ref,2), '0'), '.') }}% <img src="{{ asset('public/bp/img/more2.png') }}" alt="">
        </a>
      </div>
      <div class="table">
        <div class="thead">
          <div></div>
          <div>রেফারেল (ব্যবহারকারী)</div>
          <div>জমা</div>
          <div>উত্তোলন</div>
        </div>

        <div class="row">
          <div>আজ</div>
          <div>
            <span class="tag">{{ $third_level_users->count() }}</span>
          </div>
          <div class="today_money_number">{{ $bdt($lv3Recharge) }}</div>
          <div class="today_income_number">{{ $bdt($lv3Withdraw) }}</div>
        </div>

        <div class="row">
          <div>মোট</div>
          <div>
            <span class="tag">{{ $third_level_users->count() }}</span>
          </div>
          <div class="total_money_number">{{ $bdt($lv3Recharge) }}</div>
          <div class="total_income_number">{{ $bdt($lv3Withdraw) }}</div>
        </div>
      </div>
    </div>
  </div>

  <div class="spacer"></div>
</div>

<!-- menu area -->
@include('app.layout.manu')

<!-- === Script Area === -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<script src="{{ asset('assets/toast.js') }}"></script>
@include('alert-message')
@include('app.layout.js')
</body>
</html>
