<!DOCTYPE html>
<html lang="bn">
<head>
    @include('app.layout.css')
    <style>
        /* === Page BG === */
        .wrapper.team-page, .wrapper.profile-page{background:#ededed}

        /* === Top bar === */
        .topbar{display:flex;justify-content:space-between;align-items:center;background:#fff;color:#29be00;padding:12px 16px;font-weight:900}
        .topbar i{cursor:pointer}

        /* === Tabs === */
        .card_menu{width:95%;margin:10px auto 0;background:#fff;border-radius:10px;overflow:hidden;display:flex}
        .card_menu_one,.card_menu_two{
            flex:1;text-align:center;padding:10px 0;font-weight:600;color:#000;border-bottom:2px solid transparent;cursor:pointer
        }
        .card_menu_one.active,.card_menu_two.active{border-bottom-color:#e11d48}

        /* === Screenshot-style card === */
        .hx-card{background:#fff;border-radius:12px;box-shadow:0 2px 16px rgba(0,0,0,.06);margin:14px 12px;overflow:hidden}
        .hx-head{background:#2ba64a;color:#fff;padding:10px 14px;border-top-left-radius:12px;border-top-right-radius:12px;font-weight:800}
        .hx-body{padding:12px 14px}
        .hx-row{display:flex;justify-content:space-between;align-items:center;margin:8px 0}
        .hx-row .k{color:#6b7280}
        .hx-row .v{font-weight:900;color:#ef4444}
        .status-pill{display:inline-block;padding:6px 14px;border-radius:999px;color:#fff;font-weight:900;font-size:12px}
        .st-success{background:#19a45a}
        .st-failed{background:#e11d48}
        .st-pending{background:#f59e0b}
        .hx-foot{background:#2ba64a;text-align:center}
        .proof-btn{display:block;width:100%;border:none;background:transparent;color:#fff;padding:12px 10px;font-weight:900;cursor:pointer}
        .hx-meta{font-weight:300;color:#6b7280;font-size:12px}

        /* Old inline styles kept working — these hide/override them gracefully */
        ._card{box-shadow:none;border-radius:12px;padding:0;background:transparent}
    </style>
</head>
<body>
<div class="wrapper profile-page" style="padding-top:0">
    <!-- Top bar -->
    <div class="topbar">
        <div onclick="window.location.href='{{route('mine')}}'"><i class="fa fa-chevron-left"></i></div>
        <div>আমার হিস্ট্রি</div>
        <div></div>
    </div>

    <!-- Tabs -->
    <div class="card_menu">
        <div class="card_menu_one active" onclick="rechargeTab()">জমা</div>
        <div class="card_menu_two" onclick="withdrawTab()">উত্তোলন</div>
    </div>

    <!-- ===== উত্তোলন হিস্ট্রি ===== -->
    <div class="container" id="withdraw" style="display:none">
        @foreach(\App\Models\Withdrawal::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
            @php
                $statusText = $element->status === 'approved' ? 'Success' : ($element->status === 'rejected' ? 'Failed' : 'Processing');
                $statusCls  = $element->status === 'approved' ? 'st-success' : ($element->status === 'rejected' ? 'st-failed' : 'st-pending');
            @endphp

            <div class="hx-card">
                <div class="hx-head">Order number : {{ $element->oid }}</div>
                <div class="hx-body">
                    <div class="hx-row">
                        <div class="k">Amount</div>
                        <div class="v">৳ {{ preg_replace('/[^\d\.,-]/','', price($element->final_amount)) }}</div>
                    </div>
                    <div class="hx-row">
                        <div class="k">State</div>
                        <div class="status-pill {{ $statusCls }}">{{ $statusText }}</div>
                    </div>
                    <div class="hx-row">
                        <div class="k">Date</div>
                        <div class="hx-meta">{{ $element->created_at }}</div>
                    </div>
                </div>
                <!-- Screenshot অনুযায়ী: Withdraw এ সবসময় বাটন থাকবে -->
                <div class="hx-foot">
                    <a href="{{ route('user.withdraw') }}" class="proof-btn">Add Proof of withdrawal</a>
                </div>
            </div>
        @endforeach
    </div>

    <!-- ===== জমা হিস্ট্রি ===== -->
    <div class="container" id="recharge" style="display:block">
        @foreach(\App\Models\Deposit::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
            @php
                $statusText = $element->status === 'approved' ? 'Success' : ($element->status === 'rejected' ? 'Failed' : 'Processing');
                $statusCls  = $element->status === 'approved' ? 'st-success' : ($element->status === 'rejected' ? 'st-failed' : 'st-pending');
                $showProof  = $element->status === 'rejected'; /* Screenshot: Failed হলে বাটন দেখাও */
            @endphp

            <div class="hx-card">
                <div class="hx-head">Order number : {{ $element->oid }}</div>
                <div class="hx-body">
                    <div class="hx-row">
                        <div class="k">Amount</div>
                        <div class="v">৳ {{ preg_replace('/[^\d\.,-]/','', price($element->final_amount)) }}</div>
                    </div>
                    <div class="hx-row">
                        <div class="k">State</div>
                        <div class="status-pill {{ $statusCls }}">{{ $statusText }}</div>
                    </div>
                    <div class="hx-row">
                        <div class="k">Date</div>
                        <div class="hx-meta">{{ $element->created_at }}</div>
                    </div>
                </div>

                @if($showProof)
                    <div class="hx-foot">
                        <a href="{{ route('user.deposit') }}" class="proof-btn">Add Proof of recharge</a>
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</div>

<!-- menu area -->
@include('app.layout.manu')

<!-- === Script Area === -->
@include('app.layout.js')

<script>
    function rechargeTab(){
        document.getElementById('recharge').style.display = 'block';
        document.getElementById('withdraw').style.display = 'none';
        document.querySelector('.card_menu_one').classList.add('active');
        document.querySelector('.card_menu_two').classList.remove('active');
    }
    function withdrawTab(){
        document.getElementById('recharge').style.display = 'none';
        document.getElementById('withdraw').style.display = 'block';
        document.querySelector('.card_menu_two').classList.add('active');
        document.querySelector('.card_menu_one').classList.remove('active');
    }
</script>
</body>
</html>
