<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ env('APP_NAME') }} — প্যাকেজ বিস্তারিত</title>

  <!-- Base CSS -->
  <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/details.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

  <style>
    :root{
      --green:#1f8b4c;
      --orange:#f4511e;
      --ink:#0f172a;
      --muted:#6b7280;
      --bg:#f7f7f7;
      --card:#ffffff;
      --line:#e5e7eb;
      --chip:#e8f5ee;
    }
    *{ box-sizing:border-box; }
    body{ margin:0; background:var(--bg); color:var(--ink); font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif; }

    .page{ padding-bottom:90px; }

    .headerid{ background:#fff; box-shadow:0 1px 0 rgba(0,0,0,.05); }
    .headerid .flex_sta img{ width:28px; height:28px; object-fit:contain; margin-right:8px; }
    .idtitle{ margin:0; font-size:12px; color:var(--muted); }
    .userid{ margin:0; font-weight:900; }

    .detailimg{ width:100%; max-height:220px; height:auto; display:block; object-fit:cover; }

    .modaltitle{
      margin:12px; background:#fff; padding:12px; border-radius:12px;
      font-weight:900; color:#0f172a; box-shadow:0 1px 0 rgba(0,0,0,.03);
      display:flex; align-items:center; gap:10px;
    }
    .pill{ width:30px; height:30px; border-radius:10px; background:var(--chip);
      border:1px solid rgba(31,139,76,.35); color:var(--green);
      display:flex; align-items:center; justify-content:center; font-weight:900; }

    .metrics{ margin:12px; display:grid; grid-template-columns:repeat(3,1fr); gap:10px; }
    .metric{
      background:#fff; border:1px solid var(--line); border-radius:12px; padding:12px;
      text-align:center;
    }
    .metric .label{ margin:0; font-size:12px; color:var(--muted); font-weight:700; }
    .metric .val{ margin:4px 0 0; font-weight:900; color:var(--green); font-size:18px; }

    .desc{ margin:12px; background:#fff; border:1px solid var(--line); border-radius:12px; padding:12px; }
    .desc h4{ margin:0 0 8px; font-weight:900; }
    .desc p{ margin:0; white-space:pre-wrap; line-height:1.6; }

    .buybottom{
      position:fixed; left:0; right:0; bottom:0; background:#fff; border-top:1px solid var(--line);
      padding:10px 12px; z-index:9; gap:12px;
    }
    .price p{ margin:0; color:var(--muted); font-size:12px; }
    .price h4{ margin:2px 0 0; color:var(--green); font-weight:900; }

    .buybutton button{
      background:var(--green); color:#fff; border:none; border-radius:12px; padding:12px 16px; font-weight:900; cursor:pointer;
    }
    .buybutton button[disabled]{
      background:#a3a3a3; cursor:not-allowed; opacity:.7;
    }

    .alert-box{
      margin:12px; border-radius:12px; padding:12px; text-align:center; font-weight:700;
      border:1px solid #f5bcbc; background:#ffe9e9; color:#b30000;
    }
    .alert-box.success{
      border-color:#b4f0c4; background:#e8fff2; color:#0a7a29;
    }

    @media (max-width:480px){ .metrics{ grid-template-columns:1fr 1fr; } }
    .duration p, .duration p span{ overflow-wrap:anywhere; }
  </style>
</head>
<body>
<div class="page">
  <div class="centeritem">
    <div class="headerid flex_be">
      <div class="flex_sta">
        <img src="{{ asset('public/bp/img/logo.png') }}" alt="লোগো">
        <div>
          <p class="idtitle">আইডি</p>
          <p class="userid">{{ auth()->user()->username }}</p>
        </div>
      </div>
      <div class="flex_sta">
        <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সাপোর্ট"></a>
        <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
      </div>
    </div>

    <input type="hidden" id="TOKEN" value="49c890c2efac48a5c3dad70d47640e79">

    <img
      src="{{ $package->photo ? asset($package->photo) : 'https://www.bp.com/content/dam/bp/business-sites/en/global/corporate/images-jpg-png/news-and-insights/bp-magazine/10-things-hero-image-16x9.jpg' }}"
      class="detailimg" alt="প্যাকেজ ইমেজ">

    <h3 class="modaltitle">
      <span class="pill">৳</span>
      {{ $package->name }}
    </h3>

    @php
      $dailyRet = $package->validity > 0 ? ($package->commission_with_avg_amount / $package->validity) : 0;
      $fmt = fn($n)=>'৳ '.preg_replace('/[^\d\.,]/','', price($n));
      // ✅ ইউজারের রেফার কাউন্ট (ref_by = আমার ref_id)
      $referralCount = \App\Models\User::where('ref_by', auth()->user()->ref_id)->count();
      $locked = $package->referral_enabled && ($referralCount < $package->referral_required);
    @endphp

    <div class="metrics">
      <div class="metric">
        <p class="label">মেয়াদ</p>
        <p class="val">{{ $package->validity }} দিন</p>
      </div>
      <div class="metric">
        <p class="label">দৈনিক ROI</p>
        <p class="val">{{ $package->ROI }}%</p>
      </div>
      <div class="metric">
        <p class="label">দৈনিক রিটার্ন</p>
        <p class="val">{{ $fmt($dailyRet) }}</p>
      </div>
    </div>

    <div class="metrics" style="grid-template-columns:1fr 1fr;">
      <div class="metric">
        <p class="label">অবস্থা</p>
        <p class="val" style="color:#0f172a">{{ $package->status == 'active' ? 'সক্রিয়' : 'নিষ্ক্রিয়' }}</p>
      </div>
      <div class="metric">
        <p class="label">মোট আয় (গড়)</p>
        <p class="val">{{ $fmt($package->commission_with_avg_amount) }}</p>
      </div>
    </div>

    {{-- ✅ রেফারেল শর্ত নোটিশ --}}
    @if($package->referral_enabled)
      @if($locked)
        <div class="alert-box">
          🔒 এই প্ল্যান আনলক করতে কমপক্ষে <strong>{{ $package->referral_required }}</strong> জন রেফার লাগবে।<br>
          আপনার বর্তমান রেফার: <strong>{{ $referralCount }}</strong>
        </div>
      @else
        <div class="alert-box success">
          ✅ রেফারেল শর্ত পূরণ হয়েছে — আপনি প্ল্যানটি কিনতে পারবেন।
        </div>
      @endif
    @endif

    <div class="desc">
      <h4>বিস্তারিত</h4>
      <p>{{ $package->title }}</p>
    </div>
  </div>
</div>

<!-- নিচের স্থায়ী বার: মূল্য + ক্রয় -->
<div class="buybottom flex_be">
  <div class="price">
    <p>মূল্য</p>
    <h4>{{ '৳ '.preg_replace('/[^\d\.,]/','', price($package->price)) }}</h4>
  </div>
  <div class="buybutton">
    @if($locked)
      <button type="button" disabled title="রেফারেল শর্ত পূরণ হয়নি">ক্রয় লকড</button>
    @else
      <button type="button" onclick="window.location.href='{{ route('purchase.confirmation', $package->id) }}'">
        ক্রয় করুন
      </button>
    @endif
  </div>
</div>

<!-- পেমেন্ট উইন্ডো (আপনার আগের UI থাকলো; এখন দরকার নেই) -->
<div class="coverbg" style="display:none"></div>
<div class="paywind" style="display:none">
  <div class="flex_be paytitle">
    <img src="{{ asset('public/bp/img/ayicon.png') }}" alt="">
    <h5>অর্ডার নিশ্চিত করুন</h5>
    <img class="close" src="{{ asset('public/bp/img/close1.png') }}" alt="">
  </div>

  <h5 class="goodsname product-name"></h5>

  <div class="duration">
    <p>মেয়াদ: <span class="product-cycle"></span> দিন</p>
    <p>মূল্য: <span>৳ <span class="product-money"></span></span></p>
    <p>দৈনিক ROI: <span><span class="product-rate"></span>%</span></p>
    <p>দৈনিক রিটার্ন: <span>৳ <span class="product-day-profit"></span></span></p>
    <p>মোট রিটার্ন: <span>৳ <span class="product-total-profit"></span></span></p>
  </div>

  <div class="line"></div>

  <h5 class="goodsname">অনুগ্রহ করে পেমেন্ট পদ্ধতি নির্বাচন করুন</h5>
  <ul class="flex_be getway">
    <li class="flex_be active" data-type="1" data-platform="QePay">
      <p>গেটওয়ে ১</p><div class="point"><div class="innerpoint"></div></div>
    </li>
    <li class="flex_be" data-type="3" data-platform="AkPay">
      <p>গেটওয়ে ২</p><div class="point"><div class="innerpoint"></div></div>
    </li>
  </ul>
</div>

<script>
  (function(){
    if(!window.$) return;
    $(document).on('click','.getway li',function(){
      $(this).addClass('active').siblings().removeClass('active');
    });
    $(document).on('click','.close,.coverbg',function(){
      $('.paywind').slideUp(300); $('.coverbg').hide();
    });
  })();
</script>
</body>
</html>
