<html lang="bn">
<head>
  @include('app.layout.css')
  @include('app.layout.loading')

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>অর্ডার</title>

  <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/order.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

  <style>
    :root{
      --green:#1f8b4c; --ink:#0f172a; --muted:#64748b;
      --card:#ffffff; --bg:#f3f4f6; --line:#ececec;
      --danger:#ef4444; --accent:#16a34a;
      --grad: linear-gradient(90deg,#14b86e,#0aa65b);
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif}
    .page-wrap{padding-bottom:92px}

    /* ===== Appbar (স্ক্রিনশট স্টাইল) ===== */
    .headerid{position:sticky;top:0;z-index:5;background:var(--grad);border-bottom:1px solid var(--line)}
    .headergrid{display:grid;grid-template-columns:40px 1fr 40px;align-items:center;padding:10px 12px;color:#fff}
    .hback{display:flex;align-items:center;justify-content:flex-start}
    .hback a{display:inline-flex;align-items:center;gap:6px;text-decoration:none;color:#fff;font-weight:900}
    .hback a::before{content:"‹";font-weight:900;font-size:20px;line-height:1}
    .apptitle{margin:0;text-align:center;font-weight:900}
    .hghost{display:flex;align-items:center;justify-content:center}
    .brand, .idtitle, .userid, .hbtn{display:none}

    .orders{padding:12px}
    .order-card{position:relative;background:#fff;border-radius:16px;box-shadow:0 2px 10px rgba(0,0,0,.05);padding:12px;margin-bottom:12px;overflow:hidden}

    .shot-date{position:absolute;right:12px;top:10px;background:#f87171;color:#fff;border-radius:14px;padding:6px 10px;font-weight:900;font-size:12px}

    .shot-metrics{display:grid;grid-template-columns:1fr;justify-items:center;text-align:center;margin-top:4px}
    .shot-metrics .m{display:flex;flex-direction:column;gap:2px}
    .shot-metrics .v{color:#10b981;font-weight:900;font-size:22px;line-height:1}
    .shot-metrics .k{color:#94a3b8;font-weight:800;font-size:12px}

    .shot-body{display:flex;align-items:center;gap:10px;margin:12px 0}
    .shot-thumb{width:50px;height:50px;border-radius:10px;overflow:hidden;border:1px solid #e5e7eb;background:#f8fafc;flex:0 0 50px}
    .shot-thumb img{width:100%;height:100%;object-fit:cover}
    .shot-titles h4{margin:0;font-weight:900;font-size:16px}
    .shot-titles .sub{margin:2px 0 0;color:#f97316;font-size:12px;font-weight:800}
    .shot-cta{margin-left:auto}
    .shot-btn{border:1px solid #fca5a5;background:#fff;color:#ef4444;border-radius:999px;padding:6px 10px;font-weight:900;cursor:default}

    .shot-bottom{display:flex;align-items:center;justify-content:space-between;background:#ff6b6b;color:#fff;border-radius:12px;padding:10px 12px;margin-top:8px;font-weight:900}

    .order-top, .order-main .kv, .order-main .price, .progress{display:none}
    .order-main{display:block;margin:0}
    .thumb{display:none}
  </style>
</head>
<body>
@php
  use App\Models\Purchase;

  $activeCount  = Purchase::where('status','active')->where('user_id', user()->id)->count();
  $dailyIncome  = Purchase::where('status','active')->where('user_id', user()->id)->sum('daily_income');
  $orders       = Purchase::where('user_id', auth()->id())->where('status','active')->orderByDesc('id')->get();

  $bdt = fn($v)=> str_replace('$','৳', price($v)); // safe helper
@endphp

<div class="page-wrap">
  <div class="headerid">
    <div class="headergrid">
      <div class="hback"><a href="javascript:history.back()">ফিরে</a></div>
      <h3 class="apptitle">পণ্য</h3>
      <div class="hghost"></div>
    </div>
  </div>

  <div class="summary" style="display:none"></div>

  <div class="orders">
    @forelse($orders as $plan)
      @php
        $element           = $plan->package;

        // মোট দিন
        $validDays         = (int) ($element->validity ?? 0);

        // ইতোমধ্যে সম্পন্ন দিন (নেগেটিভ/ওভারফ্লো সেফ)
        $doneDaysRaw       = (int) ($plan->count_return ?? 0);
        $doneDays          = max(0, min($doneDaysRaw, $validDays));

        // বাকি দিন/ঘণ্টা (প্রতিদিন গেলে কমে)
        $leftDays          = max(0, $validDays - $doneDays);
        $remainingHours    = $leftDays * 24;

        // দৈনিক আয় = মোট আয় / মোট দিন (divide-by-zero সেফ)
        $dailyEarn         = ($validDays > 0)
                              ? ($element->commission_with_avg_amount / $validDays)
                              : 0;

        // বর্তমান সঞ্চিত আয় = দৈনিক আয় × সম্পন্ন দিন (Validity এর বেশি না)
        $earningSoFar      = $dailyEarn * $doneDays;

        $datePill          = now()->format('d-m-Y H:i:s');
      @endphp

      <div class="order-card">
        <div class="shot-date">{{ $datePill }}</div>

        <!-- শুধু দৈনিক আয় -->
        <div class="shot-metrics">
          <div class="m">
            <div class="v">Tk{{ rtrim(rtrim(number_format($dailyEarn,2), '0'), '.') }}</div>
            <div class="k">দৈনিক আয়</div>
          </div>
        </div>

        <!-- প্রোডাক্ট লাইন -->
        <div class="shot-body">
          <div class="shot-thumb">
            <img src="{{ asset($element->photo) }}" alt="">
          </div>
          <div class="shot-titles">
            <!-- ✅ এখন বাকি সময় (ঘণ্টা) দেখাবে এবং প্রতিদিন কমবে -->
            <h4>{{ $element->name }}</h4>
            <div class="sub">Working for {{ $remainingHours }} Hours</div>
          </div>
          <div class="shot-cta">
            <button type="button" class="shot-btn">কর্মক্ষেত্রে</button>
          </div>
        </div>

        <!-- নিচের লাল বার -->
        <div class="shot-bottom">
          <span>সময়কাল: {{ $doneDays }} / {{ $validDays }}</span>
          <!-- ✅ প্রতিদিনের ইনকাম যোগ হয়ে চলমান মোট দেখাবে -->
          <span>বর্তমান আয় : {{ rtrim(rtrim(number_format($earningSoFar,2), '0'), '.') }}</span>
        </div>

        <!-- মূল ব্লকগুলো অপরিবর্তিত রেখে হাইড -->
        <div class="order-top">
          <div class="order-brand">
            <img src="{{ asset('public/bp/img/logo.png') }}" alt="">
            <p style="margin:0;font-weight:900">BP</p>
          </div>
          <p class="order-no">{{ $plan->oid ?? ('ORD-'.str_pad($plan->id, 6, '0', STR_PAD_LEFT)) }}</p>
        </div>

        <div class="order-main">
          <div class="thumb">
            <img src="{{ asset($element->photo) }}" alt="">
          </div>
          <div class="meta">
            <p class="title">{{ $element->name }}</p>
            <p class="price">{{ $bdt($element->price) }}</p>
            <div class="kv">
              <p>দৈনিক ROI: <strong>{{ rtrim(rtrim(number_format($element->ROI,2), '0'), '.') }}%</strong></p>
              <p>দৈনিক রিটার্ন: <strong>{{ $bdt($dailyEarn) }}</strong></p>
              <p>মেয়াদ: <strong>{{ $validDays }} দিন</strong></p>
              <p>মোট সম্ভাব্য আয়: <strong>{{ $bdt($element->commission_with_avg_amount) }}</strong></p>
            </div>
            <div class="progress">
              <span>উপার্জন: <b>{{ $bdt($earningSoFar) }}</b> / {{ $validDays }} দিন</span>
              <span class="next">পরবর্তী আয়: {{ \Carbon\Carbon::parse($plan->next_return_date)->format('d M, h:i A') }}</span>
            </div>
          </div>
        </div>
      </div>
    @empty
      <div class="empty">কোনও সক্রিয় অর্ডার পাওয়া যায়নি</div>
    @endforelse
  </div>
</div>

@include('app.layout.manu')
@include('app.layout.js')
</body>
</html>
