<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>প্রশ্নোত্তর (FAQ)</title>

  <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/me.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

  <style>
    :root{
      --green:#1f8b4c; --ink:#0f172a; --muted:#64748b;
      --card:#ffffff; --bg:#f7f7f7; --line:#ececec; --chip:#e8f5ee;
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif}
    .page-wrap{padding-bottom:90px}

    /* ===== Header (sticky) ===== */
    .headerid{position:sticky;top:0;z-index:5;background:#fff;border-bottom:1px solid var(--line)}
    .headergrid{display:grid;grid-template-columns:1fr 40px 40px;align-items:center;padding:10px 12px}
    .h-left{display:flex;align-items:center;gap:10px}
    .h-left img{width:22px;height:22px}
    .h-left div{font-weight:900}
    .h-right a{display:flex;align-items:center;justify-content:center}
    .h-right img{width:22px;height:22px}

    /* ===== Banner / Title ===== */
    .banner{padding:12px}
    .hero{background:linear-gradient(135deg,#e8f5ee,#ffffff);border:1px solid #dbe9e1;border-radius:16px;padding:16px}
    .hero h2{margin:0 0 6px;font-weight:900}
    .hero p{margin:0;color:#475569;font-weight:700}

    /* ===== FAQ (Accordion) ===== */
    .faq{padding:12px}
    .faq-item{background:var(--card);border:1px solid var(--line);border-radius:16px;margin-bottom:10px;overflow:hidden}
    .faq-q{display:flex;align-items:center;justify-content:space-between;gap:10px;padding:12px 14px;cursor:pointer}
    .faq-q h3{margin:0;font-weight:900;font-size:16px}
    .faq-q p{margin:0;color:#334155;font-weight:800}
    .faq-q .q-left{display:flex;align-items:center;gap:10px}
    .q-badge{display:inline-flex;align-items:center;justify-content:center;width:26px;height:26px;border-radius:8px;background:var(--chip);border:1px solid rgba(31,139,76,.35);color:var(--green);font-weight:900;font-size:12px}
    .q-arrow{width:18px;height:18px;transition:transform .2s ease}
    .faq-item.open .q-arrow{transform:rotate(180deg)}

    .faq-a{display:none;padding:0 14px 14px}
    .faq-a p{margin:0;color:#111;font-weight:700;line-height:1.6}
    .faq-item.open .faq-a{display:block}

    /* ===== CTA Box ===== */
    .cta{padding:12px}
    .service{display:flex;align-items:center;justify-content:space-between;background:#fff;border:1px solid var(--line);border-radius:16px;padding:12px}
    .service .left{display:flex;align-items:center;gap:10px}
    .service .left img{width:26px;height:26px}
    .service a{display:inline-block;background:var(--green);color:#fff;text-decoration:none;padding:8px 12px;border-radius:12px;font-weight:900}

    .smalllogo{text-align:center;margin-top:14px}
    .smalllogo img{width:120px}
    .copyright{text-align:center;color:#94a3b8;margin:6px 0 0;font-weight:800}
  </style>
</head>
<body>
<div class="page-wrap">

  <!-- Header -->
  <div class="centeritem">
    <div class="headerid">
      <div class="headergrid">
        <div class="h-left">
          <img src="{{ asset('public/bp/img/back.png') }}" alt="পিছনে">
          <div>প্রশ্নোত্তর (FAQ)</div>
        </div>
        <a class="h-right" href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সহায়তা"></a>
        <a class="h-right" href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
      </div>
    </div>
  </div>

  <input type="hidden" id="TOKEN" value="2e3c3a3917102cf0892e428707dd8df7">

  <!-- Banner -->
  <div class="banner">
    <div class="hero">
      <h2>আপনার প্রশ্নের উত্তর এক জায়গায়</h2>
      <p>ডিপোজিট/উত্তোলন কিংবা অ্যাকাউন্ট–সংশ্লিষ্ট ঘনঘন জিজ্ঞাসার উত্তর দেখুন।</p>
    </div>
  </div>

  <!-- FAQ -->
  <div class="faq">

    <!-- Q1 -->
    <div class="faq-item">
      <div class="faq-q" onclick="toggleFaq(this)">
        <div class="q-left">
          <span class="q-badge">Q1</span>
          <div>
            <h3>ডিপোজিট দেখাচ্ছে না?</h3>
            <p>ডিপোজিট করার পর ট্রানজ্যাকশন ভেরিফাই না হলে কী করবেন</p>
          </div>
        </div>
        <img class="q-arrow" src="{{ asset('public/bp/img/more2.png') }}" alt="">
      </div>
      <div class="faq-a">
        <p>
          অনুগ্রহ করে সিস্টেমে নিচের ৩টি তথ্য আপলোড করুন। আমরা ২৪ ঘন্টার মধ্যে যাচাই করে অর্ডার কনফার্ম করব।<br>
          ১) ব্যাংক/ওয়ালেটের স্ট্যান্ডার্ড ট্রানজ্যাকশন রসিদ<br>
          ২) প্রেরকের নাম<br>
          ৩) প্রাপকের ব্যাংক অ্যাকাউন্ট নম্বর/ওয়ালেট ঠিকানা
        </p>
      </div>
    </div>

    <!-- Q2 -->
    <div class="faq-item">
      <div class="faq-q" onclick="toggleFaq(this)">
        <div class="q-left">
          <span class="q-badge">Q2</span>
          <div>
            <h3>উত্তোলন “প্রসেসিং” দেখাচ্ছে</h3>
            <p>উত্তোলন স্ট্যাটাস “Processing” হলে এর মানে কী?</p>
          </div>
        </div>
        <img class="q-arrow" src="{{ asset('public/bp/img/more2.png') }}" alt="">
      </div>
      <div class="faq-a">
        <p>
          “প্রসেসিং” মানে আপনার উত্তোলন ব্যাংক/পেমেন্ট গেটওয়ে প্রসেস করছে। সাধারণত ২৪ ঘন্টার মধ্যেই সম্পন্ন হয়।
          নির্ধারিত সময় পার হলে আমাদের কাস্টমার সার্ভিসে যোগাযোগ করুন।
        </p>
      </div>
    </div>

    <!-- Q3 -->
    <div class="faq-item">
      <div class="faq-q" onclick="toggleFaq(this)">
        <div class="q-left">
          <span class="q-badge">Q3</span>
          <div>
            <h3>উত্তোলন ব্যর্থ হয়েছে</h3>
            <p>উত্তোলন “Failed/Rejected” হলে কী করবেন</p>
          </div>
        </div>
        <img class="q-arrow" src="{{ asset('public/bp/img/more2.png') }}" alt="">
      </div>
      <div class="faq-a">
        <p>
          আপনার ব্যাংক/ওয়ালেট তথ্য সঠিক আছে কিনা যাচাই করুন (অ্যাকাউন্ট নাম, নম্বর/ঠিকানা, ব্রাঞ্চ/নেটওয়ার্ক ইত্যাদি)।
          প্রয়োজন হলে <b>প্রোফাইল &gt; ব্যাংক কার্ড যুক্ত করুন</b> পেজে সঠিক তথ্য আপডেট করে পুনরায় উত্তোলনের চেষ্টা করুন।
        </p>
      </div>
    </div>

    <!-- Q4 (ঐচ্ছিক অতিরিক্ত) -->
    <div class="faq-item">
      <div class="faq-q" onclick="toggleFaq(this)">
        <div class="q-left">
          <span class="q-badge">Q4</span>
          <div>
            <h3>ফি ও সীমা</h3>
            <p>ন্যূনতম/সর্বোচ্চ উত্তোলন ও চার্জ সম্পর্কে</p>
          </div>
        </div>
        <img class="q-arrow" src="{{ asset('public/bp/img/more2.png') }}" alt="">
      </div>
      <div class="faq-a">
        <p>
          ন্যূনতম উত্তোলন ও ফি প্ল্যাটফর্মের সেটিং অনুসারে পরিবর্তনশীল। উত্তোলনের আগে “উত্তোলন” পেজে প্রদর্শিত
          তথ্য দেখুন। সকল পরিমাণ টাকা **৳** (টাকা) কারেন্সিতে গণনা করা হয়।
        </p>
      </div>
    </div>

  </div>

  <!-- Customer Service CTA -->
  <div class="cta">
    <div class="service">
      <div class="left">
        <img src="{{ asset('public/bp/img/kf.png') }}" alt="">
        <div>
          <div style="font-weight:900">কাস্টমার সার্ভিস</div>
          <div style="color:#475569;font-weight:700;font-size:13px">২৪×৭ সহায়তা পেতে ট্যাপ করুন</div>
        </div>
      </div>
      <a href="{{ \App\Models\Setting::first()->telegram }}">চ্যাট করুন</a>
    </div>
  </div>

  <!-- Footer -->
  <div class="smalllogo">
    <img src="{{ asset('public/bp/img/copyright.png') }}" alt="">
  </div>
  <p class="copyright">BP p.l.c. কপিরাইট © 1996–2024</p>
</div>

@include('app.layout.manu')
@include('alert-message')

<script>
  // Accordion toggle
  function toggleFaq(el){
    const item = el.closest('.faq-item');
    item.classList.toggle('open');
  }
</script>
</body>
</html>
