<html lang="bn">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আমার</title>

    <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
    <link rel="stylesheet" href="{{ asset('public/bp/me.css') }}">
    <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

<style>
  /* ===== Color System (শুধু রং/ডিজাইন পরিবর্তন) ===== */
  :root{
    --green:#1faf62;         /* প্রাইমারি সবুজ */
    --green-600:#179451;     /* হোভার/একটিভ */
    --ink:#0f172a;           /* টেক্সট ডার্ক */
    --muted:#64748b;         /* সাবটেক্সট */
    --card:#ffffff;          /* কার্ড */
    --bg:#f6fbf8;            /* পেজ ব্যাকগ্রাউন্ড (হালকা সবুজ আভা) */
    --line:#e6f2eb;          /* সফট বর্ডার */
    --chip:#e8f5ee;          /* আইকন ব্যাকগ্রাউন্ড */
  }

  *{box-sizing:border-box}
  body{
    margin:0;
    background:var(--bg);
    color:var(--ink);
    font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif
  }
  .page-wrap{padding-bottom:92px}

  /* ===== Header (sticky) ===== */
  .headerid{
    position:sticky;top:0;z-index:5;
    background:#fff;border-bottom:1px solid var(--line)
  }
  .headergrid{
    display:grid;grid-template-columns:1fr 40px 40px;align-items:center;
    padding:10px 12px
  }
  .brand{display:flex;align-items:center;gap:10px}
  .brand img{
    width:36px;height:36px;border-radius:10px;
    background:var(--chip);padding:6px;border:1px solid var(--line)
  }
  .idtitle{margin:0;color:#8da3b8;font-weight:800;font-size:12px}
  .userid{margin:0;font-weight:900}
  .hbtn{display:flex;align-items:center;justify-content:center}
  .hbtn img{width:22px;height:22px;filter:saturate(1.1)}

  /* ===== Summary / balance card ===== */
  .wrap{padding:12px}
  .balancebox .card{
    background:linear-gradient(135deg,#eef9f3,#ffffff);
    border:1px solid #d8eee4;border-radius:16px;padding:14px;
    position:relative;overflow:hidden;
    box-shadow:0 6px 18px rgba(31,175,98,0.06)
  }
  .balanceicon{width:28px;height:28px;margin-right:6px;
    background:var(--chip);border-radius:8px;padding:4px;border:1px solid var(--line)}
  .coinimg{position:absolute;right:12px;bottom:10px;width:48px;height:48px;opacity:.9}
  .balancebox .card h3{margin:8px 0 0;font-size:24px}
  .boost{
    display:flex;align-items:center;justify-content:space-between;margin-top:10px;
    background:#fff;border:1px solid var(--line);border-radius:12px;padding:10px 12px
  }
  .boost p{margin:0;font-weight:800}
  .boost a{
    display:flex;align-items:center;gap:8px;
    color:var(--green);font-weight:900;text-decoration:none
  }
  .boost a:hover{color:var(--green-600)}

  /* ===== Menu list (রং/কার্ড স্টাইল) ===== */
  .listmenu{list-style:none;margin:12px;padding:0}
  .listmenu li + li{margin-top:10px}
  .listmenu a{
    display:flex;align-items:center;justify-content:space-between;
    background:var(--card);border:1px solid var(--line);border-radius:14px;
    padding:12px 14px;text-decoration:none;color:inherit;
    transition:background .2s, border-color .2s, box-shadow .2s
  }
  .listmenu a:hover{
    border-color:#cfe8dd;
    box-shadow:0 6px 16px rgba(23,148,81,0.05);
    background:#fcfffd
  }
  .listmenu .flex_sta{display:flex;align-items:center;gap:12px}
  .listmenu .icon{
    width:34px;height:34px;border-radius:8px;
    background:var(--chip);object-fit:cover;padding:6px;border:1px solid var(--line)
  }
  .moreicon{width:18px;height:18px;opacity:.55}

  /* small copyright */
  .smalllogo{display:flex;justify-content:center;margin-top:16px}
  .smalllogo img{width:120px;opacity:.9;filter:saturate(1.1)}
  .copyright{text-align:center;color:#8aa5b8;margin:6px 0 0;font-weight:700}

  /* ===== Bottom tabbar (white+green) ===== */
  .tabbar{
    position:fixed;left:0;right:0;bottom:0;background:#ffffff;
    border-top:1px solid var(--line);padding:8px 6px;z-index:999
  }
  .tabs{display:grid;grid-template-columns:repeat(5,1fr);gap:4px;text-align:center}
  .tab a{display:flex;flex-direction:column;gap:4px;align-items:center;font-size:12px;color:#6b7f93;text-decoration:none}
  .tab .ico{width:26px;height:26px;display:flex;align-items:center;justify-content:center}
  .tab .ico img{width:100%;height:100%;object-fit:contain;filter:saturate(1.05) contrast(1.05)}
  .tab.active a{color:var(--green);font-weight:800}
  .tab.active .ico img{filter:saturate(1.2) contrast(1.1)}
  .tab a:active{transform:translateY(1px)}
</style>

  @php
    // ===== SAFE URLs =====
    $homeUrl     = Route::has('user.home')     ? route('user.home')     : url('/');
    $productsUrl = Route::has('user.products') ? route('user.products')
                  : (Route::has('user.home')   ? route('user.home').'#productsSection' : url('/#productsSection'));
    $gamesUrl    = Route::has('user.games')    ? route('user.games')    : url('https://autoearnbd.com/home#spinSection');
    $inviteUrl   = Route::has('user.invite')   ? route('user.invite')   : url('invite');
    $mineUrl     = Route::has('user.profile')  ? route('user.profile')  : url('mine');
  @endphp

    <div class="page-wrap">
      <!-- Header -->
      <div class="headerid">
        <div class="headergrid">
          <div class="brand">
            <img src="{{ asset('public/bp/img/logo.png') }}" alt="">
            <div>
              <p class="idtitle">আইডি</p>
              <p class="userid">{{ auth()->user()->username }}</p>
            </div>
          </div>
          <a class="hbtn" href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সহায়তা"></a>
          <a class="hbtn" href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
        </div>
      </div>

      <div class="wrap">
        <!-- Balance summary -->
        <div class="balancebox">
          <div class="card">
            <div class="flex_sta" style="display:flex;align-items:center">
              <img class="balanceicon" src="{{ asset('public/bp/img/balance.png') }}" alt="">
              <p style="margin:0;font-weight:900;color:#334155">ব্যালেন্স</p>
            </div>
            <h3>
              {{ str_replace('$','৳', price(auth()->user()->balance)) }}
            </h3>
            <img class="coinimg" src="{{ asset('public/bp/img/coin.png') }}" alt="">
          </div>

          <div class="boost">
            <p>অতিরিক্ত <span style="color:var(--green)">কমিশন</span> পান</p>
            <a href="{{ route('gift') }}">যান <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt=""></a>
          </div>
        </div>
      </div>

      <!-- Menu list -->
      <ul class="listmenu">
        <li>
          <a href="{{ route('pgroup') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/b98a9342e13ae6545ad878d891fb72fd.png') }}" alt="">
              <p>আমার অর্ডার</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="{{ route('record') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/aeb88491c7ab51f7a22cd9cb65785a36.png') }}" alt="">
              <p>পেমেন্ট রেকর্ড</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="{{ route('user.bank') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/9dc4d07c1be7f240793dbfee426cf1e0.png') }}" alt="">
              <p>ব্যাংক কার্ড যুক্ত করুন</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="{{ route('user.team') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/5bfebb043857770f28e614d05e0dc2df.png') }}" alt="">
              <p>রেফারেল আয়</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="{{ route('service') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/dbf6315bd73d3fd7fe6a01ee0f9ef1a2.png') }}" alt="">
              <p>প্রশ্নোত্তর (FAQ)</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="https://t.me/Autoearnbd2315">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/f98b7e6adfba01b348c08055d4d421ee.png') }}" alt="">
              <p>আমাদের চ্যানেল সাবস্ক্রাইব করুন</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="https://t.me/Autoearnbd51">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/3e5161fcb7bf4e7a78324155de6fdbce.png') }}" alt="">
              <p>কাস্টমার সার্ভিস</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>

        <li>
          <a href="{{ route('logout') }}">
            <div class="flex_sta">
              <img class="icon" src="{{ asset('public/bp/img/da48ae7614b89405a700c30828dabf90.png') }}" alt="">
              <p>লগ আউট</p>
            </div>
            <img class="moreicon" src="{{ asset('public/bp/img/more1.png') }}" alt="">
          </a>
        </li>
      </ul>

      <div class="smalllogo">
        <img src="{{ asset('public/bp/img/copyright.png') }}" alt="">
      </div>
      <p class="copyright">Auto Earn BD কপিরাইট © ২০২৫</p>
    </div>

    @include('app.layout.manu')
    @include('app.layout.js')

    <!-- Bottom Tabbar -->
    <nav class="tabbar">
      <div class="tabs">
        <div class="tab" data-tab="home">
          <a href="{{ $homeUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/home.png') }}" alt="হোম" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>হোম</span>
          </a>
        </div>
        <div class="tab" data-tab="products">
          <a href="{{ $productsUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/products.png') }}" alt="পণ্য" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>পণ্য</span>
          </a>
        </div>
    <div class="tab" data-target="spinSection">
      <a href="https://autoearnbd.com/home#spinSection">
        <div class="ico"><img src="{{ asset('public/bp/icons/game.png') }}" alt="খেলা" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>খেলা</span>
      </a>
    </div>
        <div class="tab" data-tab="invite">
          <a href="{{ $inviteUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/share2.png') }}" alt="শেয়ার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>শেয়ার</span>
          </a>
        </div>
        <div class="tab" data-tab="mine">
          <a href="{{ $mineUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/me.png') }}" alt="আমার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>আমার</span>
          </a>
        </div>
      </div>
    </nav>

    <script>
      // ট্যাববারে 'আমার' ট্যাব অ্যাক্টিভ
      (function(){
        const t=document.querySelector('.tabbar .tab[data-tab="mine"]');
        if(t){ t.classList.add('active'); }
      })();
    </script>
  </body>
</html>
