<html lang="bn">
  <head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>রেফারেল প্রোগ্রাম</title>

    <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
    <link rel="stylesheet" href="{{ asset('public/bp/share.css') }}">
    <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

    <style>
      :root{
        --green:#1f8b4c; --ink:#111827; --muted:#64748b;
        --card:#ffffff; --bg:#f7f7f7; --line:#ececec;
      }
      *{box-sizing:border-box}
      body{margin:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif}
      .page-wrap{padding-bottom:92px}

      /* ===== Header (sticky) ===== */
      .headerid{position:sticky;top:0;z-index:5;background:#fff;border-bottom:1px solid var(--line)}
      .headergrid{display:grid;grid-template-columns:44px 1fr 60px;align-items:center;padding:10px 12px}
      .back{width:24px;height:24px;display:flex;align-items:center;justify-content:center;cursor:pointer}
      .title{text-align:center;font-weight:900}
      .header-actions{display:flex;gap:10px;justify-content:flex-end}
      .header-actions img{width:22px;height:22px}

      /* ===== Hero / Banner ===== */
      .hero{margin:12px}
      .hero-card{background:linear-gradient(135deg,#e8f5ee,#ffffff);border:1px solid #dbe9e1;border-radius:16px;padding:14px;display:flex;align-items:center;gap:12px}
      .hero-ico{width:44px;height:44px;border-radius:12px;background:#1f8b4c1a;display:flex;align-items:center;justify-content:center}
      .hero-ico img{width:26px;height:26px}
      .hero h3{margin:0;font-weight:900;color:#0f172a}
      .hero p{margin:2px 0 0;color:#475569;font-weight:700;font-size:13px}

      /* ===== Referral Card ===== */
      .container{padding:12px}
      .card{background:var(--card);border:1px solid var(--line);border-radius:16px;box-shadow:0 1px 0 rgba(0,0,0,.03);padding:14px}
      .label{font-weight:900;color:#0f172a;margin:0 0 6px}
      .linkbox{background:#f8faf8;border:1px solid #e6efe8;border-radius:12px;padding:10px;word-break:break-all;font-weight:800;color:#111827}
      .actions{display:flex;gap:10px;justify-content:center;margin-top:12px;flex-wrap:wrap}
      .btn{border:none;border-radius:999px;padding:10px 14px;font-weight:900;cursor:pointer}
      .btn-green{background:var(--green);color:#fff;box-shadow:0 10px 18px rgba(31,139,76,.18)}
      .btn-outline{background:#fff;border:1px solid #d1e7d9;color:#1f8b4c}

      /* ===== Commission chips ===== */
      .chips{display:flex;gap:8px;flex-wrap:wrap;margin-top:12px}
      .chip{border:1px solid rgba(31,139,76,.4);background:#fff;border-radius:999px;padding:6px 10px;font-weight:800;color:#1f8b4c;font-size:12px}

      /* ===== Note ===== */
      .note{margin-top:12px;color:#475569;font-weight:700;font-size:13px;text-align:center}

      /* ===== Bottom tabbar (white+green) ===== */
      .tabbar{position:fixed;left:0;right:0;bottom:0;background:#ffffff;border-top:1px solid var(--line);padding:8px 6px;z-index:999}
      .tabs{display:grid;grid-template-columns:repeat(5,1fr);gap:4px;text-align:center}
      .tab a{display:flex;flex-direction:column;gap:4px;align-items:center;font-size:12px;color:#64748b;text-decoration:none}
      .tab .ico{width:26px;height:26px;display:flex;align-items:center;justify-content:center}
      .tab .ico img{width:100%;height:100%;object-fit:contain;filter:saturate(1) contrast(1.05)}
      .tab.active a{color:var(--green);font-weight:800}
      .tab.active .ico img{filter:saturate(1.2) contrast(1.1)}
      .tab a:active{transform:translateY(1px)}
    </style>
  </head>
  <body>
    @php
      // ===== SAFE URLs (Facade alias Route) =====
      $homeUrl     = Route::has('user.home')     ? route('user.home')     : url('/');
      $productsUrl = Route::has('user.products') ? route('user.products')
                      : (Route::has('user.home') ? route('user.home').'#productsSection' : url('/#productsSection'));
      $gamesUrl    = Route::has('user.games')    ? route('user.games')    : url('spin');
      $inviteUrl   = Route::has('user.invite')   ? route('user.invite')   : url('invite');
      $mineUrl     = Route::has('user.profile')  ? route('user.profile')  : url('mine');

      $inviteLink = url('register').'?inviteCode='.auth()->user()->ref_id;
    @endphp

    <div class="page-wrap">
      <!-- Header -->
      <div class="headerid">
        <div class="headergrid">
          <div class="back" onclick="history.back()">
            <img src="{{ asset('public/bp/img/back.png') }}" alt="ফিরে যান">
          </div>
          <div class="title">রেফারেল প্রোগ্রাম</div>
          <div class="header-actions">
            <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সহায়তা"></a>
            <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
          </div>
        </div>
      </div>

      <!-- Hero -->
      <div class="hero">
        <div class="hero-card">
          <div class="hero-ico">
            <img src="{{ asset('public/bp/icons/share.png') }}" alt="">
          </div>
          <div>
            <h3>বন্ধু আমন্ত্রণ করুন, আয় বাড়ান</h3>
            <p>সাইনআপ বোনাস ২০৳ · কমিশন ৩০% + ৫% + ২%</p>
          </div>
        </div>
      </div>

      <!-- Referral block -->
      <div class="container">
        <div class="card">
          <div class="label">আমার রেফারেল লিংক</div>
          <div class="linkbox">{{ $inviteLink }}</div>

          <div class="actions">
            <button class="btn btn-green" onclick='copyLink(@json($inviteLink))'>লিংক কপি করুন</button>
            <a class="btn btn-outline" href="https://t.me/Autoearnbd51?text={{ urlencode($inviteLink) }}">হোয়াটসঅ্যাপে শেয়ার</a>
          </div>

          <div class="chips">
            <div class="chip">লেভেল-১ কমিশন: ৩০%</div>
            <div class="chip">লেভেল-২ কমিশন: ৫%</div>
            <div class="chip">লেভেল-৩ কমিশন: ২%</div>
          </div>

          <div class="note">যত বেশি রেফারেল, তত বেশি আয়—সমস্ত আয় আপনার ওয়ালেটে ৳ হিসেবে জমা হবে।</div>
        </div>
      </div>
    </div>

    @include('app.layout.manu')
    @include('alert-message')

    <!-- Bottom Tabbar (SAFE) -->
    <nav class="tabbar">
      <div class="tabs">
        <div class="tab" data-tab="home">
          <a href="{{ $homeUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/home.png') }}" alt="হোম" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>হোম</span>
          </a>
        </div>
        <div class="tab" data-tab="products">
          <a href="{{ $productsUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/products.png') }}" alt="পণ্য" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>পণ্য</span>
          </a>
        </div>
        <div class="tab" data-tab="spin">
          <a href="https://autoearnbd.com/home#spinSection">
            <div class="ico"><img src="{{ asset('public/bp/icons/game.png') }}" alt="খেলা" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>খেলা</span>
          </a>
        </div>
        <div class="tab" data-tab="invite">
          <a href="{{ $inviteUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/share2.png') }}" alt="শেয়ার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>শেয়ার</span>
          </a>
        </div>
        <div class="tab" data-tab="mine">
          <a href="{{ $mineUrl }}">
            <div class="ico"><img src="{{ asset('public/bp/icons/me.png') }}" alt="আমার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
            <span>আমার</span>
          </a>
        </div>
      </div>
    </nav>

    <script>
      // কপি ফাংশন (সিম্পল, নির্ভরযোগ্য)
      function copyLink(text){
        const input=document.createElement("input");
        document.body.appendChild(input);
        input.value=String(text);
        input.style.opacity=0;
        input.select(); input.setSelectionRange(0,input.value.length);
        document.execCommand("Copy");
        input.remove();
        message('কপি করা হয়েছে');
      }

      // ট্যাববারে 'invite' ট্যাব অ্যাক্টিভ রাখি (এই পেজ রেফারেল)
      (function(){
        const t=document.querySelector('.tabbar .tab[data-tab="invite"]');
        if(t){ t.classList.add('active'); }
      })();
    </script>
  </body>
</html>
