<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>হোম</title>

  <link rel="stylesheet" href="{{asset('public/bp/main.css')}}">
  <link rel="stylesheet" href="{{asset('public/bp/details.css')}}">
  <link rel="stylesheet" href="{{asset('public/bp/index.css')}}">
  <link rel="stylesheet" href="{{asset('public/bp/loading.css')}}">

  <style>
    :root{ --green:#1f8b4c; --orange:#f4511e; --gray-bg:#f2f3f5; --text:#1f2937; --muted:#6b7280; --card:#ffffff; --danger:#e11d48; }
    *{ box-sizing:border-box; }
    body{ background:#fafafa; color:var(--text); margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif; }
    .wrap{ padding:12px; padding-bottom:90px; }

    .section{ display:none; }
    .section.active{ display:block; }

    .top-summary{ background:var(--card); padding:14px 12px; border-radius:12px; box-shadow:0 1px 0 rgba(0,0,0,.03); }
    .ts-row{ display:flex; justify-content:space-between; align-items:center; }
    .ts-left .phone{ font-size:20px; font-weight:800; }
    .ts-left .meta{ display:flex; gap:8px; align-items:center; margin-top:4px; flex-wrap:wrap; }
    .meta .id{ color:#0ea5a5; font-weight:700; }
    .meta .vip{ background:#e5f2ff; color:#2563eb; font-weight:700; padding:2px 8px; border-radius:999px; font-size:12px; }
    .meta .quota{ background:#ecfeff; color:#0ea5a5; font-weight:900; padding:2px 8px; border-radius:999px; font-size:12px; border:1px solid #a5f3fc; }
    .ts-right{ width:56px; height:56px; border-radius:999px; background:#e8f5ee; display:flex; align-items:center; justify-content:center; overflow:hidden; }
    .ts-right img{ max-width:100%; }

    .quick-stats{ display:grid; grid-template-columns:1fr 1fr 1fr; gap:12px; margin-top:14px; }
    .qs-item{ background:var(--card); padding:12px; border-radius:12px; text-align:center; text-decoration:none; }
    .qs-item h4{ margin:2px 0 4px; color:#f4511e; font-size:20px; font-weight:900; }
    .qs-item p{ margin:0; color:var(--muted); font-size:13px; }
    .qs-link{ color:#f4511e; font-weight:800; }

    .cash-card{ background:var(--card); border-radius:12px; margin-top:12px; overflow:hidden; }
    .cash-head{ padding:12px; font-weight:800; }
    .cash-grid{ display:grid; grid-template-columns:1fr 1fr; gap:12px; padding:12px; }

    .cash-btn{ background:#f8faf8; border:1px solid #e6efe8; border-radius:12px; padding:14px 10px; text-align:center; display:flex; flex-direction:column; gap:8px; align-items:center; color:var(--green); font-weight:800; text-decoration:none; }
    .cash-btn .icon{ width:36px; height:36px; display:flex; align-items:center; justify-content:center; }
    .cash-btn .icon img{ width:100%; height:100%; object-fit:contain; }
    .cash-btn .icon svg{ width:36px; height:36px; display:none; }

    .banner{ margin:12px 0; border-radius:12px; overflow:hidden; }
    .banner img{ width:100%; display:block; }

    .p-list .item{ position:relative; background:#fff; border-radius:12px; box-shadow:0 1px 0 rgba(0,0,0,.03); padding:12px; margin-bottom:12px; overflow:hidden; }
    .p-list .quota {
      position:absolute; right:10px; top:10px;
      background:#ef4444; color:#fff; font-weight:800; font-size:12px; padding:5px 10px; border-radius:999px;
    }
    .p-list .head{ display:flex; gap:12px; }
    .p-list .thumb{ width:70px; height:70px; border-radius:10px; overflow:hidden; position:relative; flex:0 0 70px; border:1px solid #e5e7eb; background:#f8fafc; }
    .p-list .thumb img{ width:100%; height:100%; object-fit:cover; }
    .p-list .vip{ position:absolute; left:6px; top:6px; background:#eefbf3; border:1px solid #c6f0d7; color:#0e9f6e; font-weight:900; font-size:11px; padding:3px 6px; border-radius:999px; }
    .p-list .meta{ flex:1; }
    .p-list .title{ margin:0; font-weight:900; font-size:16px; color:#111827; }
    .p-list .pill{ display:inline-flex; align-items:center; gap:6px; margin-top:6px; font-size:12px; font-weight:800; color:#b45309; background:#fff7ed; border:1px solid #fdba74; padding:4px 8px; border-radius:999px; }
    .p-list .stats{ display:flex; align-items:flex-end; gap:18px; margin-top:10px; padding-left:82px; }
    .p-list .kv{ display:flex; flex-direction:column; line-height:1.1; }
    .p-list .kv .v{ color:#0d9488; font-weight:900; font-size:18px; }
    .p-list .kv .k{ color:#6b7280; font-weight:700; font-size:12px; }
    .p-list .cta{ margin-top:10px; }
    .p-list .buy{ width:100%; border:none; cursor:pointer; border-radius:999px; padding:12px 16px; font-weight:900; color:#fff; background:linear-gradient(90deg,#1e9b56,#0a8a4a); box-shadow:0 6px 16px rgba(31,139,76,.18); }
    .p-list .buy:active{ transform:translateY(1px); }

    .tabbar{ position:fixed; left:0; right:0; bottom:0; background:#ffffff; border-top:1px solid #ececec; padding:8px 6px; z-index:70; }
    .tabs{ display:grid; grid-template-columns:repeat(5,1fr); gap:4px; text-align:center; }
    .tab a{ display:flex; flex-direction:column; gap:4px; align-items:center; font-size:12px; color:#64748b; text-decoration:none; }
    .tab .ico{ width:26px; height:26px; display:flex; align-items:center; justify-content:center; }
    .tab .ico img{ width:100%; height:100%; object-fit:contain; filter: saturate(1) contrast(1.05); }
    .tab.active a{ color:var(--green); font-weight:800; }
    .tab.active .ico img{ filter: saturate(1.2) contrast(1.1); }
    .tab a:active{ transform: translateY(1px); }

    /* (অন্য সেকশন/স্পিন ইত্যাদির স্টাইল আপনার আগের মতই নিচে রয়েছে) */
    .spin-wrap{padding:12px}
    .spin-card{background:#fff;border-radius:16px;border:1px solid #e6eef3;box-shadow:0 8px 28px rgba(0,0,0,.04);padding:16px}
    .spin-title{margin:0 0 12px;font-weight:900;font-size:18px;color:#334155}
    .wheel-area{display:flex;flex-direction:column;align-items:center;gap:14px}
    .wheel-box{position:relative;width:280px;height:280px}
    .wheel{width:100%;height:100%;border-radius:50%;background:conic-gradient(#F94144 0 45deg,#F3722C 45deg 90deg,#F9C74F 90deg 135deg,#90BE6D 135deg 180deg,#43AA8B 180deg 225deg,#577590 225deg 270deg,#B5179E 270deg 315deg,#7209B7 315deg 360deg);border:10px solid #ffcc66;box-shadow:inset 0 0 0 6px #a65b00,0 12px 20px rgba(0,0,0,.12);position:relative;transition:transform 2.8s cubic-bezier(.2,.9,.2,1)}
    .wheel::after{content:'SPIN';position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);width:90px;height:90px;border-radius:50%;background:#7c2d12;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:900;letter-spacing:1px;box-shadow:inset 0 0 0 6px #f59e0b,0 6px 16px rgba(0,0,0,.25);font-size:18px}
    .pin{position:absolute;left:50%;top:-8px;transform:translateX(-50%);width:0;height:0;border-left:10px solid transparent;border-right:10px solid transparent;border-bottom:18px solid #ffd166;filter:drop-shadow(0 2px 2px rgba(0,0,0,.2))}
    .spin-btn{background:#1f8b4c;color:#fff;font-weight:900;border:none;border-radius:12px;padding:12px 18px;cursor:pointer;box-shadow:0 8px 16px rgba(31,139,76,.2)}
    .spin-btn:disabled{opacity:.6;cursor:not-allowed}
    .note{font-size:12px;color:#6b7280}

    .spin-bars{margin-top:14px;display:grid;grid-template-columns:1fr;gap:10px}
    .spin-bar{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:10px 12px;display:flex;align-items:center;gap:10px}
    .spin-bar .label{flex:1;color:#0f172a;font-weight:800}
    .spin-bar .value{background:#10b9811a;border:1px solid #10b98144;border-radius:10px;padding:6px 10px;font-weight:900;color:#0ea5a5}
    .spin-bar .value.free{background:#1f8b4c1a;border:1px solid #1f8b4c55;color:#1f8b4c}
    .spin-bar .btn{margin-left:auto;background:#ef4444;color:#fff;border:none;border-radius:10px;padding:8px 12px;font-weight:800;cursor:pointer}
    .spin-bar .help{margin-left:auto;background:#f1f5f9;border:none;border-radius:10px;padding:8px 10px;font-weight:800;color:#0f172a}

    .prd-orders{padding:12px}
    .prd-card{position:relative;background:#fff;border-radius:16px;box-shadow:0 2px 10px rgba(0,0,0,.05);padding:12px;margin-bottom:12px;overflow:hidden}
    .prd-date{position:absolute;right:12px;top:10px;background:#f87171;color:#fff;border-radius:14px;padding:6px 10px;font-weight:900;font-size:12px}
    .prd-metrics{display:grid;grid-template-columns:1fr;justify-items:center;text-align:center;margin-top:4px}
    .prd-metrics .m{display:flex;flex-direction:column;gap:2px}
    .prd-metrics .v{color:#10b981;font-weight:900;font-size:22px;line-height:1}
    .prd-metrics .k{color:#94a3b8;font-weight:800;font-size:12px}
    .prd-body{display:flex;align-items:center;gap:10px;margin:12px 0}
    .prd-thumb{width:50px;height:50px;border-radius:10px;overflow:hidden;border:1px solid #e5e7eb;background:#f8fafc;flex:0 0 50px}
    .prd-thumb img{width:100%;height:100%;object-fit:cover}
    .prd-titles h4{margin:0;font-weight:900;font-size:16px}
    .prd-titles .sub{margin:2px 0 0;color:#f97316;font-size:12px;font-weight:800}
    .prd-cta{margin-left:auto}
    .prd-btn{border:1px solid #fca5a5;background:#fff;color:#ef4444;border-radius:999px;padding:6px 10px;font-weight:900;cursor:default}
    .prd-bottom{display:flex;align-items:center;justify-content:space-between;background:#ff6b6b;color:#fff;border-radius:12px;padding:10px 12px;margin-top:8px;font-weight:900}

    .ts-actions{ display:flex; justify-content:flex-end; margin-top:10px; }
    .bonus-btn{ background:#1f8b4c; color:#fff; border:none; border-radius:10px; padding:8px 12px; font-weight:900; cursor:pointer; box-shadow:0 6px 14px rgba(31,139,76,.18) }
    .bonus-btn:active{ transform:translateY(1px) }

    .bonus-modal{ position:fixed; inset:0; display:none; z-index:999; }
    .bonus-modal.active{ display:block; }
    .bonus-topbar{ background:#1abc9c; color:#fff; display:flex; align-items:center; justify-content:center; position:sticky; top:0; height:48px; font-weight:900; }
    .bonus-topbar .back{ position:absolute; left:10px; color:#fff; text-decoration:none; font-weight:800; }
    .bonus-wrap{ position:absolute; inset:0; display:flex; flex-direction:column; }
    .bonus-list{ padding:10px 12px 18px; overflow:auto; background:#f7f7f7; }
    .b-card{ position:relative; background:#fff; border-radius:16px; border:1px solid #f0f0f0; padding:12px; margin-bottom:12px; }
    .b-title{ font-weight:900; margin:0; color:#111827; }
    .b-reward-text{ color:#ef4444; font-weight:700; font-size:12px; margin-top:4px; }
    .b-right{ position:absolute; right:12px; top:10px; text-align:center; color:#6b7280; font-weight:800; font-size:12px; }
    .b-stamp{ position:absolute; right:26px; top:22px; width:78px; height:78px; border-radius:999px; border:3px solid #f87171; color:#f87171; display:flex; align-items:center; justify-content:center; transform:rotate(-18deg); font-weight:900; opacity:.85; background:#fff; }
    .b-prog{ margin-top:10px; display:flex; align-items:center; gap:10px; }
    .b-bar{ flex:1; height:12px; border-radius:999px; background:#fde7df; overflow:hidden; }
    .b-fill{ height:100%; width:0%; background:#fda48c; }
    .b-num{ font-weight:900; color:#f97316; }
  </style>
</head>
<body>

@php
  $user = auth()->user();
  $rawPhone = $user->phone ?? $user->username ?? '';
  $masked = $rawPhone ? preg_replace('/(\+?\d{5})\d+(..)/', '$1****$2', $rawPhone) : '';
  $isVip = \App\Models\Purchase::where('user_id', auth()->id())->where('status','active')->exists();
  $routeWithdraw   = \Illuminate\Support\Facades\Route::has('user.withdraw') ? route('user.withdraw') : '#';
  $routeMessage    = \Illuminate\Support\Facades\Route::has('user.messages') ? route('user.messages') : '#';
  $routeProfile    = \Illuminate\Support\Facades\Route::has('user.profile') ? route('user.profile') : '#';
  $routeBalanceLog = \Illuminate\Support\Facades\Route::has('user.transactions') ? route('user.transactions') : '#';

  $inviteRoute = \Illuminate\Support\Facades\Route::has('user.invite') ? route('user.invite') : url('invite');

  // রেফার করা ইউজার সংখ্যা (যদি ref_by কলাম থাকে)
  $refCount = 0;
  try {
      if (\Illuminate\Support\Facades\Schema::hasColumn('users', 'ref_by')) {
          $refCount = \App\Models\User::where('ref_by', auth()->user()->ref_id ?? null)->count();
      }
  } catch (\Throwable $e) { $refCount = 0; }
@endphp

<div class="wrap">

  <!-- ========== হোম সেকশন ========== -->
  <section id="homeSection" class="section active">
    <div class="top-summary">
      <div class="ts-row">
        <div class="ts-left">
          <div class="phone">{{ $masked ?: '+88**********' }}</div>
          <div class="meta">
            <div class="id">আইডি: {{ $user->id ?? '-' }}</div>
            <div class="vip">{{ $isVip ? 'সক্রিয় VIP' : 'এখনও VIP নন' }}</div>
          </div>
        </div>
        <div class="ts-right">
          <img src="{{asset('public/bp/img/logo.png')}}" alt="logo">
        </div>
      </div>

      <div class="ts-actions">
        <a href="{{ route('user.bonus') }}" class="bonus-btn">বোনাস টাস্ক</a>
      </div>

      <div class="quick-stats">
        <a class="qs-item" href="{{ route('user.deposit') }}">
          <h4>৳ {{ preg_replace('/[^\d\.,]/','', price($user->balance ?? 0)) }}</h4>
          <p>বর্তমান ব্যালেন্স</p>
        </a>

        <a class="qs-item" href="{{ route('user.invite') }}">
          <div class="qs-link">চেক করুন</div>
          <p>প্রচার আয়</p>
        </a>

        <a class="qs-item"
           href="{{ \Illuminate\Support\Facades\Route::has('pgroup')
                    ? route('pgroup')
                    : ( \Illuminate\Support\Facades\Route::has('order') ? route('order') : url('orders') ) }}">
          <div class="qs-link">চেক করুন</div>
          <p>পণ্যের আয়</p>
        </a>
      </div>
    </div>

    <!-- অ্যাপ ডাউনলোড -->
    <a class="app-download-btn"
       href="https://app.autoearnbd.com/AutoEarnBD.apk"
       target="_blank" rel="noopener">
      <span class="play-icon" aria-hidden="true">
        <svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
          <defs>
            <linearGradient id="gp-a" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0" stop-color="#00A0FF"/><stop offset="1" stop-color="#00E3FF"/></linearGradient>
            <linearGradient id="gp-b" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0" stop-color="#FFE000"/><stop offset="1" stop-color="#FFA200"/></linearGradient>
            <linearGradient id="gp-c" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0" stop-color="#FF3A44"/><stop offset="1" stop-color="#C31162"/></linearGradient>
            <linearGradient id="gp-d" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0" stop-color="#32A071"/><stop offset="1" stop-color="#00F076"/></linearGradient>
          </defs>
          <path d="M43 71c-7 6-11 16-11 28v314c0 12 4 22 11 28L257 256 43 71z" fill="url(#gp-a)"/>
          <path d="M292 255 240 210 63 65c5-4 12-6 20-6h11l232 134-14 12z" fill="url(#gp-b)"/>
          <path d="M306 267l-14 12 214 185c-5 4-12 6-20 6h-11L240 336l52-45 14-12z" fill="url(#gp-c)"/>
          <path d="M500 101c6 6 9 15 9 26v258c0 11-3 20-9 26L292 267 500 101z" fill="url(#gp-d)"/>
        </svg>
      </span>
      <span class="texts">
        <span class="title">অ্যাপ ডাউনলোড</span>
        <span class="subtitle">সহজ ব্যবহার</span>
      </span>
    </a>

    <style>
      .app-download-btn{ display:inline-flex; align-items:center; gap:12px; background:#1f8b4c; color:#fff; text-decoration:none; padding:12px 16px; border-radius:12px; box-shadow:0 6px 14px rgba(31,139,76,.18); transition:transform .06s ease, box-shadow .2s ease, background .2s ease; }
      .app-download-btn:hover{ background:#187542; box-shadow:0 8px 18px rgba(31,139,76,.25); }
      .app-download-btn:active{ transform:translateY(1px); }
      .app-download-btn .play-icon{ width:28px; height:28px; display:inline-flex; }
      .app-download-btn .texts{ display:flex; flex-direction:column; line-height:1.1; }
      .app-download-btn .title{ font-weight:800; font-size:15px; }
      .app-download-btn .subtitle{ font-size:12px; opacity:.9; }
      @media (max-width: 480px){ .app-download-btn{ width:100%; justify-content:center; } }
    </style>

    <div class="cash-card">
      <div class="cash-head">জমা এবং টাকা তোলা</div>
      <div class="cash-grid">
        <a class="cash-btn" href="{{ route('user.deposit') }}">
          <span class="icon">
            <img src="{{ asset('public/bp/icons/deposit.png') }}" alt="জমা" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
              <path d="M12 3v12m0 0l-4-4m4 4l4-4M4 19h16" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </span>
          <div>জমা</div>
        </a>

        <a class="cash-btn" href="{{ $routeWithdraw }}">
          <span class="icon">
            <img src="{{ asset('public/bp/icons/withdraw.png') }}" alt="উত্তোলন" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
              <path d="M12 21V9m0 0l4 4m-4-4l-4 4M4 5h16" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </span>
          <div>উত্তোলন</div>
        </a>
      </div>

      <div class="banner">
        <a href="{{ route('user.invite') }}">
          <img src="{{asset('public/bp/img/0e29acd3d20e32fc977bf5bf06fdaa4c.png')}}" alt="প্রচার">
        </a>
      </div>
    </div>

    <!-- হোমে পণ্য লিস্ট -->
    <div id="productsList" style="margin-top:14px">
      <h3 class="modaltitle">পণ্য কিনুন</h3>

      @foreach(\App\Models\Package::where('status', 'active')->get() as $element)
        @php
          // দাম/আয়
          $price     = preg_replace('/[^\d\.,]/','', price($element->price));
          $totalRet  = preg_replace('/[^\d\.,]/','', price($element->commission_with_avg_amount));
          $dailyRet  = preg_replace('/[^\d\.,]/','', price(max(0, $element->commission_with_avg_amount) / max(1,$element->validity)));
          $daysTotal = (int) $element->validity;

          // ইউজার ঐ প্যাকেজ কতবার কিনেছে
          $sameCount = \App\Models\Purchase::where('user_id', auth()->id())
                        ->where('package_id', $element->id)
                        ->count();

          // অ্যাডমিন সেট করা প্রতি-ইউজার লিমিট (0 = আনলিমিটেড)
          $maxPerUser = (int)($element->max_per_user ?? 0);
          $limitText  = $maxPerUser > 0 ? $maxPerUser : '0';
        @endphp

        <div class="p-list">
          <div class="item">
            <!-- ✅ ক্রয়/কোটা ব্যাজ -->
            <div class="quota">ক্রয়/কোটা {{ $sameCount }} / {{ $limitText }}</div>

            <div class="head">
              <div class="thumb">
                <img src="{{ asset($element->photo) }}" alt="প্যাকেজ">
                <div class="vip">VIP</div>
              </div>
              <div class="meta">
                <h4 class="title">{{ $element->name }}</h4>
                <div class="pill">
                  <span>বাজেট চক্র</span><strong>{{ $daysTotal }} দিন</strong>
                </div>
              </div>
            </div>

            <div class="stats">
              <div class="kv"><div class="v">Tk {{ $dailyRet }}</div><div class="k">দৈনিক আয়</div></div>
              <div class="kv"><div class="v">Tk {{ $totalRet }}</div><div class="k">মোট আয়</div></div>
            </div>

            <div class="cta">
              <a href="{{ route('package.details', $element->id) }}">
                <button class="buy">কিনুন {{ $price }}</button>
              </a>
            </div>
          </div>
        </div>
      @endforeach
    </div>
  </section>

  <!-- ========== আমার VIP প্ল্যান ========== -->
  <section id="productsSection" class="section">
    @php
      $orders = \App\Models\Purchase::where('user_id', auth()->id())->where('status','active')->orderByDesc('id')->get();
      $bdt = fn($v)=> str_replace('$','৳', price($v));
    @endphp

    <div class="prd-orders">
      @forelse($orders as $plan)
        @php
          $p            = $plan->package;
          $validDays    = (int)($p->validity ?? 0);
          $doneDaysRaw  = (int)($plan->count_return ?? 0);
          $doneDays     = max(0, min($doneDaysRaw, $validDays));
          $leftDays     = max(0, $validDays - $doneDays);
          $remainingHrs = $leftDays * 24;
          $dailyEarn    = $validDays > 0 ? ($p->commission_with_avg_amount / $validDays) : 0;
          $earningSoFar = $dailyEarn * $doneDays;
          $datePill     = now()->format('d-m-Y H:i:s');
        @endphp

        <div class="prd-card">
          <div class="prd-date">{{ $datePill }}</div>
          <div class="prd-metrics">
            <div class="m">
              <div class="v">Tk{{ rtrim(rtrim(number_format($dailyEarn,2), '0'), '.') }}</div>
              <div class="k">দৈনিক আয়</div>
            </div>
          </div>
          <div class="prd-body">
            <div class="prd-thumb"><img src="{{ asset($p->photo ?? null) }}" alt="VIP"></div>
            <div class="prd-titles">
              <h4>{{ $p->name ?? null}}</h4>
              <div class="sub">আর {{ $remainingHrs }} ঘন্টা চলবে</div>
            </div>
            <div class="prd-cta"><button type="button" class="prd-btn">কর্মরত</button></div>
          </div>
          <div class="prd-bottom">
            <span>সময়কাল: {{ $doneDays }} / {{ $validDays }}</span>
            <span>বর্তমান আয়: {{ rtrim(rtrim(number_format($earningSoFar,2), '0'), '.') }}</span>
          </div>
        </div>
      @empty
        <div style="padding:16px;text-align:center;color:#94a3b8;font-weight:800">কোনো সক্রিয় প্ল্যান নেই</div>
      @endforelse
    </div>
  </section>

  <!-- ========== খেলা (SPIN) ========== -->
  <section id="spinSection" class="section">
    <div class="spin-wrap">
      <div class="spin-card">
        <h3 class="spin-title">স্পিন গেম</h3>
        <div class="wheel-area">
          <div class="wheel-box">
            <div class="pin"></div>
            <div id="wheel" class="wheel"></div>
          </div>
          <button id="spinBtn" class="spin-btn">SPIN</button>
          <div class="note">১টি Invite = ১টি Free Spin • প্রতি Spin এ Tk 5</div>
        </div>

        <div class="spin-bars">
          <div class="spin-bar">
            <div class="label">ব্যালেন্স</div>
            <div class="value" id="spinBalance">Tk <span id="spinBalanceVal">0</span></div>
            <button class="help" id="spinRulesBtn">রুলস</button>
          </div>
          <div class="spin-bar">
            <div class="label">ফ্রি স্পিন</div>
            <div class="value free">Free <span id="spinCredits">0</span></div>
            <a class="btn" href="{{ $inviteRoute }}" id="inviteOpenBtn">Invite</a>
          </div>
        </div>
      </div>
    </div>
  </section>

</div><!-- /.wrap -->

<!-- গ্লোবাল পেমেন্ট মডাল (আগের মতই) -->
<div class="coverbg"></div>
<div class="paywind">
  <div class="flex_be paytitle">
    <img src="{{asset('public/bp/img/ayicon.png')}}" alt="">
    <h5>অর্ডার নিশ্চিত করুন</h5>
    <img class="close" src="{{asset('public/bp/img/close1.png')}}" alt="">
  </div>

  <h5 class="goodsname product-name"></h5>

  <div class="duration">
    <p>মেয়াদ: <span class="product-cycle"></span> দিন</p>
    <p>মূল্য: <span>৳ <span class="product-money"></span></span></p>
    <p>দৈনিক ROI: <span><span class="product-rate"></span>%</span></p>
    <p>দৈনিক রিটার্ন: <span>৳ <span class="product-day-profit"></span></span></p>
    <p>মোট রিটার্ন: <span>৳ <span class="product-total-profit"></span></span></p>
  </div>

  <div class="line"></div>

  <h5 class="goodsname">অনুগ্রহ করে পেমেন্ট পদ্ধতি নির্বাচন করুন</h5>
  <ul class="flex_be getway">
    <li class="flex_be active" data-type="1" data-platform="QePay">
      <p>গেটওয়ে ১</p><div class="point"><div class="innerpoint"></div></div>
    </li>
    <li class="flex_be" data-type="3" data-platform="AkPay">
      <p>গেটওয়ে ২</p><div class="point"><div class="innerpoint"></div></div>
    </li>
  </ul>

  <div class="confirm buyBtn">
    পরিশোধ নিশ্চিত করুন: <span>৳ <span class="product-money"></span></span>
  </div>
</div>

<nav class="tabbar">
  <div class="tabs">
    <div class="tab" data-target="homeSection">
      <a href="home">
        <div class="ico"><img src="{{ asset('public/bp/icons/home.png') }}" alt="হোম" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>হোম</span>
      </a>
    </div>

    <div class="tab" data-target="productsSection">
      <a href="products">
        <div class="ico"><img src="{{ asset('public/bp/icons/products.png') }}" alt="পণ্য" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>পণ্য</span>
      </a>
    </div>

    <div class="tab" data-target="spinSection">
      <a href="spin">
        <div class="ico"><img src="{{ asset('public/bp/icons/game.png') }}" alt="খেলা" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>খেলা</span>
      </a>
    </div>

    <div class="tab">
      <a href="{{ route('user.invite') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/share2.png') }}" alt="শেয়ার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>শেয়ার</span>
      </a>
    </div>

    <div class="tab">
      <a href="{{ Route::has('user.profile') ? route('user.profile') : url('mine') }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/me.png') }}" alt="আমার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>আমার</span>
      </a>
    </div>
  </div>
</nav>

<script>
  // Tabs
  (function(){
    const tabs=document.querySelectorAll('.tabbar .tab');
    const sections=document.querySelectorAll('.section');
    function showSection(id){ sections.forEach(s=>s.classList.remove('active')); const sec=document.getElementById(id); if(sec){ sec.classList.add('active'); window.scrollTo({top:0, behavior:'smooth'});} }
    function setActiveByTarget(targetId){ tabs.forEach(t=>t.classList.remove('active')); const t=document.querySelector(`.tabbar .tab[data-target="${targetId}"]`); if(t) t.classList.add('active'); }
    document.querySelectorAll('.tabbar .tab a').forEach(a=>{
      a.addEventListener('click',function(e){
        const tab=this.closest('.tab'); const target=tab?tab.getAttribute('data-target'):null; const hasSection=target&&document.getElementById(target);
        if(hasSection){ e.preventDefault(); setActiveByTarget(target); showSection(target); history.replaceState(null,'',`#${target}`); }
        else{ tabs.forEach(t=>t.classList.remove('active')); if(tab) tab.classList.add('active'); }
      });
    });
    (function(){ const hash=(location.hash||'').replace('#',''); const id=document.getElementById(hash)?hash:'homeSection'; setActiveByTarget(id); showSection(id); })();
  })();

  // পেমেন্ট পপআপ
  var alipay_id="0", is_status=true;
  $(function(){
    $(document).on('click','.buybtn1',function(){
      $('.product-name').text($(this).data('product-name'));
      $('.product-cycle').text($(this).data('product-cycle'));
      $('.product-money').text($(this).data('product-money'));
      $('.product-rate').text($(this).data('product-rate'));
      $('.product-day-profit').text($(this).data('product-day-profit'));
      $('.product-total-profit').text($(this).data('product-total-profit'));
      alipay_id=$(this).data('product-id');
      $('.coverbg').show(); $('.paywind').slideDown(300);
    });
    $(document).on('click','.getway li',function(){ $(this).addClass('active').siblings().removeClass('active') });
    $(document).on('click','.close,.coverbg',function(){ $('.paywind').slideUp(300); $('.coverbg').hide(); });
    $(document).on('click','.buyBtn',function(){
      let dom=$('.getway li.active'); let type=dom.data('type'), platform=dom.data('platform');
      if(!type){ Toast('অনুগ্রহ করে একটি পেমেন্ট গেটওয়ে নির্বাচন করুন',2000); return false; }
      if(!alipay_id){ Toast('অনুগ্রহ করে আগে একটি প্রোডাক্ট নির্বাচন করুন',2000); return false; }
      if(!is_status){ return false; }
      loading.showLoading({ type:1, tip:"লোড হচ্ছে..." }); is_status=false;
      var TOKEN="2da1930e31ffa72bd26f38fe88748581";
      $.post("/money/recharge.html", z({type:type,alipay_id:alipay_id,platform:platform,TOKEN:TOKEN}), function(msg){
        loading.hideLoading(); is_status=true;
        if(msg.code==1){ $("#my_form").html(' '); $("#my_form").append(msg.data); $("body").find('#yqfForm').submit(); }
        else if(msg.code==2){ window.location.href=msg.data; }
        else if(msg.code==9998 || msg.code==0){ successToast(msg.data, ()=>{window.location.href=msg.data.url;}) }
        else{ Toast(msg.data,3000); }
      }, 'json')
    });

    if(typeof Swiper!=='undefined'){
      new Swiper(".swiper-container2",{ spaceBetween:15, loop:true, autoplay:{delay:2000, disableOnInteraction:false}, navigation:{nextEl:".swiper-button-next", prevEl:".swiper-button-prev"}, pagination:{el:".swiper-pagination", clickable:true} });
    }
  });

  // SPIN GAME JS
  (function(){
    const wheel=document.getElementById('wheel');
    const btn=document.getElementById('spinBtn');
    if(!wheel||!btn) return;

    const SERVER_REF_COUNT = {{ (int)$refCount }};

    const K_USED='ag_free_spins_used';
    const K_BAL ='ag_spin_balance';
    const getUsed=()=>parseInt(localStorage.getItem(K_USED)||'0',10);
    const setUsed=v=>localStorage.setItem(K_USED,String(Math.max(0,v)));
    const getBal =()=>parseInt(localStorage.getItem(K_BAL)||'0',10);
    const setBal =v=>localStorage.setItem(K_BAL,String(Math.max(0,v)));

    const creditsEl=document.getElementById('spinCredits');
    const balanceEl=document.getElementById('spinBalanceVal');
    function availableSpins(){ return Math.max(0, SERVER_REF_COUNT - getUsed()); }
    function refreshBars(){ if(creditsEl) creditsEl.textContent=availableSpins(); if(balanceEl) balanceEl.textContent=getBal(); }
    refreshBars();

    let spinning=false, baseDeg=0;
    btn.addEventListener('click', function(){
      if(spinning) return;
      if(availableSpins()<=0){
        const msg='আর ফ্রি স্পিন নেই। Invite করে ফ্রি স্পিন নিন।';
        if(typeof Toast==='function'){ Toast(msg,2200); } else { alert(msg); }
        window.location.href='{{ $inviteRoute }}';
        return;
      }
      spinning=true; btn.disabled=true;
      setUsed(getUsed()+1); refreshBars();

      const turns=360*(5+Math.floor(Math.random()*3));
      const rand=Math.floor(Math.random()*360);
      const deg=baseDeg+turns+rand;
      wheel.style.transform=`rotate(${deg}deg)`;
      setTimeout(()=>{
        setBal(getBal()+5); refreshBars();
        if(typeof successToast==='function'){ successToast('অভিনন্দন! আপনি Tk 5 পেয়েছেন'); }
        else{ alert('অভিনন্দন! আপনি Tk 5 পেয়েছেন'); }
        spinning=false; btn.disabled=false; baseDeg=deg%360;
      },2900);
    });
  })();
</script>
</body>
</html>
