<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ env('APP_NAME') }} — এক্সচেঞ্জ</title>

  <!-- Favicon -->
  <link rel="icon" href="{{ asset('footbal/assets/image/favicon.ico') }}">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer"/>
  <!-- Base CSS (আপনার প্রজেক্ট) -->
  <link rel="stylesheet" href="{{ asset('footbal/assets/css/global.css') }}">
  <link rel="stylesheet" href="{{ asset('footbal/assets/css/style.css') }}">
  <link rel="stylesheet" href="{{ asset('footbal/assets/css/setting.css') }}">
  <link rel="stylesheet" href="{{ asset('rahat/app.css') }}">

  <style>
    :root{
      --green:#1f8b4c;
      --ink:#0f172a;
      --muted:#64748b;
      --bg:#ededed;
      --card:#ffffff;
      --line:#e5e7eb;
      --chip:#e8f5ee;
    }
    *{ box-sizing:border-box; }
    body{ background:var(--bg); color:var(--ink); margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif; }

    /* ===== Page Header ===== */
    .page_title{
      display:grid; grid-template-columns:40px 1fr 40px;
      align-items:center; background:#fff; color:var(--green);
      padding:12px 14px; border-bottom:1px solid var(--line);
      position:sticky; top:0; z-index:5;
    }
    .page_title > div:nth-child(2){ text-align:center; font-weight:900; }
    .page_title i{ font-weight:900; cursor:pointer; }

    /* ===== Center Illustration / Loader ===== */
    .previewWrap{ text-align:center; padding:18px 12px; }
    .previewWrap img{ width:120px; height:auto; object-fit:contain; }
    .loadingWrap{ display:none; position:fixed; left:50%; top:18%; transform:translateX(-50%); z-index:99; }
    .loadingWrap img{ width:92px; height:92px; border-radius:50%; }

    /* ===== Card Form (Unique White & Green) ===== */
    .giftCard{
      background:var(--card); border:1px solid var(--line);
      border-radius:16px; padding:16px; width:min(560px,92%); margin:10px auto 0;
      box-shadow:0 1px 0 rgba(0,0,0,.02);
    }
    .giftHead{
      display:flex; align-items:center; gap:10px; margin-bottom:10px;
    }
    .giftHead .chip{
      display:inline-flex; align-items:center; justify-content:center;
      width:34px; height:34px; border-radius:10px; background:var(--chip);
      color:var(--green); font-weight:900; border:1px solid rgba(31,139,76,.35);
    }
    .giftHead h3{ margin:0; font-weight:900; }
    .giftHead p{ margin:0; color:var(--muted); font-weight:700; }

    .formRow{ margin-top:12px; }
    label{ display:block; font-size:14px; font-weight:800; color:#0f172a; margin-bottom:6px; }
    .inputbox{
      width:100%; border:1px solid var(--line); border-radius:12px; padding:12px 12px;
      background:#f8faf8; outline:0; font-size:16px;
    }
    .inputbox::placeholder{ color:#9ca3af; }

    .hint{
      font-size:13px; color:#334155; background:#f6fffa; border:1px dashed rgba(31,139,76,.35);
      padding:10px 12px; border-radius:12px; margin-top:10px; font-weight:700;
    }

    .submitWrap{ margin-top:16px; display:flex; gap:10px; }
    .btn{
      border:none; border-radius:12px; padding:12px 14px; font-weight:900; cursor:pointer;
    }
    .btn-primary{ background:var(--green); color:#fff; flex:1; }
    .btn-soft{ background:#fff; color:var(--green); border:1px solid rgba(31,139,76,.35); }

    /* ===== Success/Policy Cards (Optional) ===== */
    .infoRow{ width:min(560px,92%); margin:12px auto 0; display:grid; gap:10px; }
    .infoCard{
      background:#fff; border:1px solid var(--line); border-radius:14px; padding:12px;
    }
    .infoCard h4{ margin:0 0 6px; font-weight:900; color:#0f172a; }
    .infoCard p{ margin:0; color:#334155; font-weight:700; line-height:1.5; }

    /* ===== Footer space so keyboard / toasts overlap না করে ===== */
    .page-pad{ height:24px; }
  </style>
</head>
<body>

@include('alert-message')

<div class="setting_container">
  <!-- Header -->
  <div class="page_title">
    <div onclick="window.location.href='{{ route('mine') }}'"><i class="fa fa-chevron-left"></i></div>
    <div>এক্সচেঞ্জ</div>
    <div></div>
  </div>

  <!-- Preview / Loader -->
  <div class="previewWrap" id="pre">
    <img src="{{ asset('images__3_-removebg-preview.png') }}" alt="প্রিভিউ">
  </div>
  <div class="loadingWrap" id="wi">
    <img src="{{ asset('giphy (1).gif') }}" alt="লোড হচ্ছে">
  </div>

  <!-- Gift Code Card -->
  <form action="javascript:void(0)" method="post" class="giftCard" id="giftForm">@csrf
    <div class="giftHead">
      <span class="chip"><i class="fa fa-gift"></i></span>
      <div>
        <h3>গিফট কোড এক্সচেঞ্জ</h3>
        <p>সঠিক কোড ব্যবহার করলে সাথে সাথে আপনার অ্যাকাউন্টে বোনাস যুক্ত হবে (৳)।</p>
      </div>
    </div>

    <div class="formRow">
      <label for="bonus_code">গিফট কোড</label>
      <input id="bonus_code" type="text" name="bonus_code" class="inputbox" placeholder="উদাহরণ: AB12-XY34-ZZ99" autocomplete="one-time-code">
    </div>

    <div class="hint">
      টিপস: কপি/পেস্ট করার সময় বাড়তি স্পেস যেন না থাকে। কোড ভুল হলে এক্সচেঞ্জ হবে না।
    </div>

    <div class="submitWrap">
      <button class="btn btn-primary" id="submitBtn" onclick="submitBonusRequest()">গ্রহণ করুন</button>
      <button class="btn btn-soft" type="button" onclick="document.getElementById('bonus_code').value=''">কোড মুছুন</button>
    </div>
  </form>

  <!-- Policy / Help -->
  <div class="infoRow">
    <div class="infoCard">
      <h4>এক্সচেঞ্জ নীতিমালা</h4>
      <p>একটি কোড একবারই ব্যবহারযোগ্য। কোড মেয়াদোত্তীর্ণ হলে এক্সচেঞ্জ হবে না। প্রয়োজন হলে সহায়তার জন্য টেলিগ্রামে যোগাযোগ করুন।</p>
    </div>
    <div class="infoCard">
      <h4>সহায়তা</h4>
      <p>সমস্যা হলে স্ক্রিনশটসহ জানালে দ্রুত সমাধান করা হবে।</p>
    </div>
  </div>

  <div class="page-pad"></div>
</div>

<meta name="csrf-token" content="{{ csrf_token() }}">
<script src="{{ asset('footbal/assets/js/jquery-3.7.0.min.js') }}"></script>
<script src="{{ asset('footbal/assets/js/script.js') }}"></script>

<script>
  let submitting = false;

  function toggleLoader(show){
    const wi = document.getElementById('wi');
    const pre = document.getElementById('pre');
    if(show){
      wi.style.display='block';
      pre.style.opacity='0.35';
    }else{
      wi.style.display='none';
      pre.style.opacity='1';
    }
  }

  function submitBonusRequest(){
    if(submitting) return; // ডাবল-সাবমিট গার্ড

    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const input = document.getElementById('bonus_code');
    const code = (input.value || '').trim();

    if(!code){
      message('অনুগ্রহ করে গিফট কোড লিখুন!');
      input.focus();
      return;
    }

    submitting = true;
    toggleLoader(true);
    document.getElementById('submitBtn').disabled = true;

    fetch('{{ route('user.submit-bonus') }}', {
      method: "POST",
      headers: {
        "Content-Type": "application/json; charset=UTF-8",
        "Accept": "application/json",
        "X-CSRF-TOKEN": csrfToken
      },
      body: JSON.stringify({ bonus_code: code })
    })
    .then(async (response)=>{
      // যদি রেসপন্স JSON না হয়, fallback বার্তা
      let data = {};
      try { data = await response.json(); } catch(e) {}
      return { ok: response.ok, status: response.status, data };
    })
    .then(({ok, status, data})=>{
      input.value = '';
      const msg = (data && data.message) ? data.message : (ok ? 'এক্সচেঞ্জ সম্পন্ন হয়েছে' : 'এক্সচেঞ্জ ব্যর্থ হয়েছে');
      setTimeout(()=>{ message(msg); }, 300);

      // 4s অপেক্ষার প্রয়োজন নেই—ইউএক্স ফাস্ট রাখা হলো
    })
    .catch((err)=>{
      console.error(err);
      message('নেটওয়ার্ক ত্রুটি! আবার চেষ্টা করুন।');
    })
    .finally(()=>{
      submitting = false;
      toggleLoader(false);
      document.getElementById('submitBtn').disabled = false;
    });
  }

  // Enter প্রেসে সাবমিট
  document.getElementById('bonus_code').addEventListener('keydown', function(e){
    if(e.key === 'Enter'){ e.preventDefault(); submitBonusRequest(); }
  });
</script>
</body>
</html>
