<!doctype html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>ব্যালেন্স – রিচার্জ</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css"/>
    <link rel="stylesheet" href="{{asset('rahat/app.css')}}">
</head>
<body>
<style>
  :root{
    --green:#1f8b4c;
    --white:#ffffff;
  }
  input[type="text"]{
    width:92%;
    margin:auto;
    margin-left:1px;
    font-size:10px;
    padding:12px 10px;
    border:1px solid #00000038;
    border-radius:5px;
  }
  button{
    background:var(--green);
    padding:10px 60px;
    border-radius:50px;
    color:var(--white);
    border:none;
    font-weight:700;
  }
  .card.mt-2{
    background:var(--green);
    margin-top:4px;
    padding:14px 0;
    border-radius:8px;
    color:var(--white);
    text-align:center;
  }
  .card.mt-2 .card-body ul{ list-style:disc; padding-left:24px; margin:0; }
  .page_title{
    display:grid; grid-template-columns:40px 1fr 40px; align-items:center;
    padding:12px 10px; background:#fff; box-shadow:0 1px 0 rgba(0,0,0,.05);
    font-weight:800;
  }
  .page_title > div:nth-child(2){ text-align:center; }
</style>

<div class="page_title">
    <div></div>
    <div>রিচার্জ সম্পন্ন</div>
    <div></div>
</div>

<div class="card mt-2">
  <div class="card-body">
    <ul>
      <li style="color:#fff;">রিচার্জ সফলভাবে সম্পন্ন হয়েছে। অনুগ্রহ করে অ্যাডমিন অনুমোদনের জন্য অপেক্ষা করুন।</li>
    </ul>
  </div>
</div>

<!-- ১০ সেকেন্ড পরে রিডাইরেক্ট -->
<h3 class="header_time" style="margin:0;color:#fff;opacity:0;">
  <span id="timer" data-hours="00" data-minutes="0" data-seconds="10"></span>
</h3>

@include('alert-message')

<script>
  const oneSec = 1000,
        container = document.getElementById('timer');

  let dataHours   = container.getAttribute('data-hours')   || "0",
      dataMinutes = container.getAttribute('data-minutes') || "0",
      dataSeconds = container.getAttribute('data-seconds') || "0",
      timerOnEndMsg = "data-timer-end";

  let hoursSpan = document.createElement('span'),
      minutesSpan = document.createElement('span'),
      secondsSpan = document.createElement('span'),
      separator2 = document.createElement('span'),
      separatorValue = ":",
      max = 59,
      s = Math.min(parseInt(dataSeconds), max),
      m = Math.min(parseInt(dataMinutes), max),
      h = parseInt(dataHours);

  secondsSpan.classList.add('time');
  minutesSpan.classList.add('time');
  hoursSpan.classList.add('time');
  separator2.classList.add('separator');
  separator2.textContent = separatorValue;

  const checkValue = (v)=> (v < 10 ? "0"+v : v);

  hoursSpan.textContent   = checkValue(h);
  minutesSpan.textContent = checkValue(m);
  secondsSpan.textContent = checkValue(s);

  const timer = (sv,mv,hv)=>{
    s = parseInt(sv); m = parseInt(mv); h = parseInt(hv);
    if (s > 0) { return s -= 1; }
    s = max;
    if (m > 0) { return m -= 1; }
    m = max;
    if (h > 0) { return h -= 1; }
  }

  const finished = ()=>{
    container.setAttribute(timerOnEndMsg, 'true');
    window.location.href='{{route('user.deposit')}}';
  }

  const counter = setInterval(()=>{
    if (h == 0 && m == 0 && s == 0) {
      clearInterval(counter, finished());
    }
    if (s >= 0) {
      timer(s,m,h);
      hoursSpan.textContent   = checkValue(h);
      minutesSpan.textContent = checkValue(m);
      secondsSpan.textContent = checkValue(s);
    }
  }, oneSec);

  let children = [minutesSpan, separator2, secondsSpan];
  for (child of children) { container.appendChild(child); }
</script>

</body>
</html>
