<!doctype html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>ব্যালেন্স রিচার্জ</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css"/>
  <link rel="stylesheet" href="{{asset('rahat/app.css')}}">

  <style>
    :root{
      --green:#1f8b4c;
      --white:#ffffff;
      --muted:#6b7280;
      --line:#ececec;
      --card:#fff;
      --bg:#f7f7f7;
    }
    *{ box-sizing:border-box }
    body{ background:var(--bg); margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif; color:#111827; }

    /* Header */
    .page_title{
      display:grid; grid-template-columns:40px 1fr 40px; align-items:center;
      padding:12px 10px; background:#fff; box-shadow:0 1px 0 rgba(0,0,0,.05);
      position:sticky; top:0; z-index:5;
    }
    .page_title > div:nth-child(2){ text-align:center; font-weight:800; }

    /* Cards */
    .container{ margin:0 12px; }
    .card{ background:var(--card); border:1px solid var(--line); border-radius:14px; padding:14px; box-shadow:0 1px 0 rgba(0,0,0,.02); }

    /* Amount + Timer card (green) */
    .hero{
      background:var(--green); color:#fff; text-align:center;
      border-radius:14px; padding:16px 12px; margin:12px;
      box-shadow:0 10px 24px rgba(31,139,76,.18);
    }
    .amt{ font-size:26px; font-weight:900; margin:0 }
    .sub{ margin:6px 0 2px; font-weight:700; opacity:.95 }
    .time{ font-weight:900; letter-spacing:1px; }

    /* Info rows */
    .info-list{ list-style:none; margin:0; padding:0 }
    .info-item{
      display:flex; justify-content:space-between; align-items:center;
      padding:14px 0; border-bottom:1px solid #00000022;
      font-weight:700;
    }
    .info-item:last-child{ border-bottom:none }
    .info-key{ color:#0000007a }
    .copy-btn{ width:20px; height:20px; cursor:pointer; margin-left:6px; }

    /* Inputs */
    .text-input{
      width:100%; height:42px; border:1px solid rgba(0,0,0,.22);
      border-radius:10px; padding:0 12px; outline:0; font-weight:700;
    }

    /* CTA */
    .cta{ text-align:center; margin-top:18px }
    .cta button{
      background:var(--green); color:#fff; border:none; border-radius:12px;
      padding:12px 18px; font-weight:900; width:100%;
    }
    .note{ color:var(--green); font-size:12px; font-weight:700; }

    /* Method header */
    .method-head{ display:flex; justify-content:center; align-items:center; gap:10px; margin:12px 0 6px }
    .method-name{ font-weight:900; font-size:22px }
    .method-logo{ width:46px; height:46px; border-radius:10px; object-fit:cover; border:1px solid var(--line); }

  </style>
</head>
<body>

<!-- Header -->
<div class="page_title">
  <div onclick="window.location.href='{{url('deposit')}}'" style="cursor:pointer">
    <img src="{{asset('icons8-left-chevron-25.png')}}" alt="পিছনে">
  </div>
  <div>রিচার্জ</div>
  <div></div>
</div>

<!-- Green amount + timer -->
<div class="hero">
  <h3 class="amt">৳ {{ preg_replace('/[^\d\.,-]/','', price($amount)) }}</h3>
  <p class="sub">কাউন্টডাউন</p>
  <h3 class="time">
    <span id="timer" data-hours="00" data-minutes="10" data-seconds="00"></span>
  </h3>
</div>

<form action="{{route('recharge.confirm.submit')}}" method="post">@csrf
  <div class="container">

    <!-- Method header -->
    <div class="method-head">
      <div class="method-name">{{$payment_method->name}}</div>
      <img class="method-logo" src="{{asset($payment_method->photo)}}" alt="">
    </div>

    <!-- Details -->
    <div class="card" style="margin-top:8px">
      <ul class="info-list">
        <li class="info-item">
          <div class="info-key">অ্যাকাউন্ট মেথড</div>
          <div>
            {{$payment_method->name}}
            <img class="copy-btn" onclick="copyLink('{{$payment_method->name}}')" src="https://img.icons8.com/small/16/copy.png" alt="কপি">
          </div>
        </li>
        <li class="info-item">
          <div class="info-key">ব্যাংকের নাম</div>
          <div>USDT</div>
        </li>
        <li class="info-item">
          <div class="info-key">ঠিকানা</div>
          <div>PROFELAR</div>
        </li>
        <li class="info-item">
          <div class="info-key">অ্যাকাউন্ট</div>
          <div>
            {{$payment_method->address}}
            <img class="copy-btn" onclick="copyLink('{{$payment_method->address}}')" src="https://img.icons8.com/small/16/copy.png" alt="কপি">
          </div>
        </li>
      </ul>
    </div>

    <!-- Notes + Sender name -->
    <div class="card" style="margin-top:12px">
      <p class="note">*** একই ধরনের অ্যাকাউন্টে ট্রান্সফার করুন। উদাহরণ: {{$payment_method->name}} থেকে শুধুই {{$payment_method->name}}-এ।</p>
      <p class="note">*** যে পরিমাণ তৈরি করেছেন ঠিক সেই পরিমাণই পাঠাবেন; নাহলে ডিপোজিট সফল হবে না।</p>

      <h4 style="font-size:18px; margin:10px 0 6px">টাকা পাঠানো সম্পন্ন হলে প্রেরকের অ্যাকাউন্ট নাম লিখুন</h4>
      <p class="note">টাকা পাঠানোর পর ডিপোজিট অর্ডার বাতিল করবেন না।</p>

      <div style="margin-top:12px">
        <input type="text" class="text-input" placeholder="প্রেরকের নাম লিখুন" name="transaction_id" required>
        <input type="hidden" name="paymethod" value="{{$payment_method->id}}">
        <input type="hidden" name="amount" value="{{$amount}}">
      </div>

      <div class="cta">
        <button type="submit">পেমেন্ট নিশ্চিত করুন</button>
      </div>
    </div>

    <br><br>
  </div>
</form>

@include('alert-message')

<script>
  function copyLink(text){
    const input=document.createElement("input");
    document.body.append(input);
    input.style.position="fixed"; input.style.opacity=0;
    input.value=String(text).replaceAll(' ','');
    input.select(); input.setSelectionRange(0,input.value.length);
    document.execCommand("Copy");
    input.remove();
    message('কপি সম্পন্ন হয়েছে');
  }
</script>

<script>
  var clock = document.getElementById('timer');

  var hour = 0;
  if (sessionStorage.getItem('hour')){
      hour = sessionStorage.getItem('hour');
  }
  clock.setAttribute('data-hours', hour);

  var minute = 30;
  if (sessionStorage.getItem('minute')){
      minute = sessionStorage.getItem('minute');
  }
  clock.setAttribute('data-minutes', minute);

  var second = 0;
  if (sessionStorage.getItem('second')){
      second = sessionStorage.getItem('second');
  }
  clock.setAttribute('data-seconds', second);
</script>

<script>
  const oneSec = 1000,
        container = document.getElementById('timer');

  let dataHours   = container.getAttribute('data-hours'),
      dataMinutes = container.getAttribute('data-minutes'),
      dataSeconds = container.getAttribute('data-seconds'),
      timerEnd    = container.getAttribute('data-timer-end'),
      timerOnEndMsg = "data-timer-end";

  if (!dataHours)   dataHours = "0";
  if (!dataMinutes) dataMinutes = "0";
  if (!dataSeconds) dataSeconds = "0";

  let hoursSpan = document.createElement('span'),
      minutesSpan = document.createElement('span'),
      secondsSpan = document.createElement('span'),
      separator1 = document.createElement('span'),
      separator2 = document.createElement('span'),
      separatorValue = ":",
      max = 59,
      s = Math.min(parseInt(dataSeconds), max),
      m = Math.min(parseInt(dataMinutes), max),
      h = parseInt(dataHours);

  secondsSpan.classList.add('time');
  minutesSpan.classList.add('time');
  hoursSpan.classList.add('time');
  separator1.classList.add('separator');
  separator1.textContent = separatorValue;
  separator2.classList.add('separator');
  separator2.textContent = separatorValue;

  const checkValue = (value)=> (value < 10 ? "0"+value : value);

  hoursSpan.textContent = checkValue(h);
  minutesSpan.textContent = checkValue(m);
  secondsSpan.textContent = checkValue(s);

  const timer = (sv,mv,hv)=>{
    s = parseInt(sv);
    m = parseInt(mv);
    h = parseInt(hv);
    if (s > 0) {
      return s -= 1;
    } else {
      s = max;
      if (m > 0) {
        return m -= 1;
      } else {
        m = max;
        if (h > 0) {
          return h -= 1;
        }
      }
    }
  }

  const finished = ()=>{
    max = 0;
    let timerEnd = container.getAttribute(timerOnEndMsg);
    container.setAttribute(timerOnEndMsg, 'true');
    sessionStorage.clear();
    container.textContent = timerEnd ? timerEnd : "সময় শেষ";
  }

  const counter = setInterval(()=>{
    if (h == 0 && m == 0 && s == 0) {
      clearInterval(counter, finished());
    }
    if (s >= 0) {
      timer(s,m,h);

      sessionStorage.setItem('second', checkValue(s));
      sessionStorage.setItem('minute', checkValue(m));
      sessionStorage.setItem('hour',   checkValue(h));

      hoursSpan.textContent   = checkValue(h);
      minutesSpan.textContent = checkValue(m);
      secondsSpan.textContent = checkValue(s);
    }
  }, oneSec);

  let children = [minutesSpan, separator2, secondsSpan];
  for (child of children) { container.appendChild(child); }
</script>

</body>
</html>
