<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>রিচার্জ</title>
    <!-- Google Fonts: Noto Sans Bengali -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-green: #1faa5f; /* আপনার ড্যাশবোর্ডের প্রধান সবুজ রঙ */
            --light-green-bg: #e8f7f0;
            --dark-text: #333;
            --light-text: #777;
            --page-bg: #f7f8fa;
        }

        body {
            margin: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            background-color: var(--page-bg);
            color: var(--dark-text);
        }

        .container {
            width: 100%;
            max-width: 500px; /* ডেস্কটপ ভিউ এর জন্য */
            margin: 0 auto;
            background-color: #ffffff;
            min-height: 100vh;
        }

        /* হেডার ডিজাইন */
        .header {
            background-color: var(--primary-green);
            color: white;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        .header .back-btn {
            background: none;
            border: none;
            color: white;
            cursor: pointer;
            margin-right: 15px;
        }
        .header .back-btn svg {
            width: 24px;
            height: 24px;
        }
        .header .title {
            font-size: 1.2rem;
            font-weight: 600;
            margin: 0;
        }

        .main-content {
            padding: 25px 20px;
        }

        /* ব্যালেন্স কার্ড */
        .balance-card {
            background-color: var(--light-green-bg);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            margin-bottom: 30px;
        }
        .balance-card .label {
            color: var(--light-text);
            font-size: 0.9rem;
            margin-bottom: 5px;
        }
        .balance-card .amount {
            color: var(--primary-green);
            font-size: 2.2rem;
            font-weight: 700;
        }

        /* ফর্ম ডিজাইন */
        .form-label {
            font-weight: 600;
            margin-bottom: 15px;
            display: block;
            font-size: 1.1rem;
        }

        .input-wrapper {
            position: relative;
        }
        .input-wrapper .currency-symbol {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark-text);
        }
        .amount-input {
            width: 100%;
            padding: 18px 20px 18px 60px; /* বামে জায়গা বাড়ানো হয়েছে */
            border: 1px solid #ddd;
            border-radius: 12px;
            font-size: 1.5rem;
            font-weight: 700;
            box-sizing: border-box;
            background-color: #f7f7f7;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }
        .amount-input:focus {
            outline: none;
            border-color: var(--primary-green);
            box-shadow: 0 0 0 3px rgba(31, 170, 95, 0.2);
        }

        .submit-btn {
            width: 100%;
            background-color: var(--primary-green);
            color: white;
            padding: 16px;
            font-size: 1.1rem;
            font-weight: 600;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            margin-top: 25px;
            transition: background-color 0.3s ease;
        }
        .submit-btn:hover {
            background-color: #1a8c51;
        }
        
        /* নিয়মাবলী সেকশন */
        .rules-section {
            margin-top: 40px;
        }
        .rules-section h4 {
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--dark-text);
        }
        .rules-list {
            list-style: none;
            padding: 0;
            color: var(--light-text);
        }
        .rules-list li {
            margin-bottom: 10px;
            padding-left: 25px;
            position: relative;
        }
        .rules-list li::before {
            content: '✓'; /* চেকমার্ক আইকন */
            position: absolute;
            left: 0;
            color: var(--primary-green);
            font-weight: bold;
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- হেডার -->
        <header class="header">
            <button class="back-btn" onclick="window.history.back()" aria-label="Go Back">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                </svg>
            </button>
            <h1 class="title">রিচার্জ করুন</h1>
        </header>

        <main class="main-content">
            <!-- ব্যালেন্স দেখানোর সেকশন -->
            <div class="balance-card">
                <div class="label">আপনার বর্তমান ব্যালেন্স</div>
                <div class="amount">{{ auth()->user()->deposit_balance ?? '0.00' }} ৳</div>
            </div>

            <!-- সাকসেস অথবা এরর মেসেজ -->
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif
            
            <!-- মূল ফর্ম -->
            <form action="{{ route('payment.create') }}" method="POST" id="rechargeForm">
                @csrf
                <input type="hidden" name="customer_name" value="{{ auth()->user()->name }}">
                <input type="hidden" name="customer_email" value="{{ auth()->user()->email }}">

                <div>
                    <label for="amount" class="form-label">রিচার্জ পরিমাণ</label>
                    <div class="input-wrapper">
                        <span class="currency-symbol">৳</span>
                        <input type="number" 
                               id="amount"
                               name="amount" 
                               class="amount-input @error('amount') is-invalid @enderror" 
                               placeholder="0" 
                               value="{{ old('amount') }}"
                               required
                               min="300">
                    </div>
                    @error('amount')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 8px;">{{ $message }}</div>
                    @enderror
                </div>
                
                <button type="submit" class="submit-btn">রিচার্জ করুন</button>
            </form>

            <!-- রিচার্জের নিয়মাবলী -->
            <div class="rules-section">
                <h4>রিচার্জের নিয়মাবলী</h4>
                <ul class="rules-list">
                    <li>সর্বনিম্ন রিচার্জের পরিমাণ 300 টাকা।</li>
                    <li>আপনার টাকা অ্যাকাউন্টে যোগ হতে ৫-১০ মিনিট সময় লাগতে পারে।</li>
                    <li>রিচার্জ করার আগে আপনার ইন্টারনেট সংযোগ চেক করুন।</li>
                    <li>যেকোনো সমস্যায় আমাদের কাস্টমার সাপোর্টে যোগাযোগ করুন।</li>
                </ul>
            </div>

        </main>
    </div>

</body>
</html>