{{-- resources/views/app/main/bonus.blade.php --}}
{{-- Referral Bonus Task Page (screenshot-like) --}}
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Task</title>

  <style>
    :root{
      --green:#1abc9c; --ink:#111827; --muted:#6b7280;
      --bg:#f7f7f7; --line:#ececec; --chip:#fde7df; --chip2:#fda48c;
      --danger:#f87171;
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif}
    .topbar{position:sticky;top:0;z-index:5;background:var(--green);color:#fff;height:52px;display:flex;align-items:center;justify-content:center;font-weight:900}
    .back{position:absolute;left:12px;color:#fff;text-decoration:none;font-weight:800}
    .wrap{padding:12px}

    .card{position:relative;background:#fff;border:1px solid var(--line);border-radius:16px;padding:12px;margin-bottom:12px}
    .title{margin:0 0 2px;font-weight:900}
    .reward{color:#ef4444;font-size:12px;font-weight:700}
    .right{position:absolute;right:12px;top:10px;color:var(--muted);font-weight:800;font-size:12px}

    .stamp{position:absolute;right:26px;top:22px;width:78px;height:78px;border-radius:999px;border:3px solid var(--danger);color:var(--danger);
      display:flex;align-items:center;justify-content:center;transform:rotate(-18deg);font-weight:900;opacity:.9;background:#fff}

    .prog{display:flex;align-items:center;gap:10px;margin-top:10px}
    .bar{flex:1;height:12px;border-radius:999px;background:var(--chip);overflow:hidden}
    .fill{height:100%;width:0;background:var(--chip2)}
    .num{font-weight:900;color:#f97316}

    .claim-btn{border:none;background:#1f8b4c;color:#fff;font-weight:900;padding:8px 12px;border-radius:10px;cursor:pointer;margin-top:10px}
    .claim-btn:disabled{opacity:.6;cursor:not-allowed}

    /* flash messages */
    .flash{margin:10px 12px 0;padding:10px 12px;border-radius:10px;font-weight:800}
    .flash-success{background:#ecfdf5;border:1px solid #a7f3d0;color:#065f46}
    .flash-error{background:#fef2f2;border:1px solid #fecaca;color:#991b1b}
  </style>
</head>
<body>

  <div class="topbar">
    <a href="{{ url()->previous() ?? route('dashboard') }}" class="back">ফিরে</a>
    Task
  </div>

  {{-- ✅ ফ্ল্যাশ মেসেজ (সাক্সেস/এরর) --}}
  @if(session('success'))
    <div class="flash flash-success">{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="flash flash-error">{{ session('error') }}</div>
  @endif

  @php
    // ===== Level-1 referral count (safe fallbacks) =====
    $level1 = 0;
    try {
        if (\Illuminate\Support\Facades\Schema::hasColumn('users','ref_by')) {
          $level1 = \App\Models\User::where('ref_by', auth()->id())->count();
        } elseif (\Illuminate\Support\Facades\Schema::hasColumn('users','parent_id')) {
          $level1 = \App\Models\User::where('parent_id', auth()->id())->count();
        } elseif (\Illuminate\Support\Facades\Schema::hasColumn('users','invited_by')) {
          $level1 = \App\Models\User::where('invited_by', auth()->id())->count();
        }
    } catch (\Throwable $e) { $level1 = 0; }

    // ===== লেভেল কনফিগ: DB থাকলে সেখান থেকে, নাহলে ডিফল্ট =====
    $levels = collect();
    if (class_exists(\App\Models\ReferralLevel::class)) {
      try {
        $levels = \App\Models\ReferralLevel::query()
                   ->where('is_active',1)
                   ->orderBy('target_count')
                   ->get(['id','target_count','reward_amount']);
      } catch (\Throwable $e) { $levels = collect(); }
    }
    if($levels->isEmpty()){
      $levels = collect([
        (object)['id'=>1,'target_count'=>1,  'reward_amount'=>60.00],
        (object)['id'=>2,'target_count'=>3,  'reward_amount'=>150.00],
        (object)['id'=>3,'target_count'=>7,  'reward_amount'=>400.00],
        (object)['id'=>4,'target_count'=>15, 'reward_amount'=>850.00],
        (object)['id'=>5,'target_count'=>30, 'reward_amount'=>1500.00],
        (object)['id'=>6,'target_count'=>50, 'reward_amount'=>2500.00],
      ]);
    }

    // ===== ইতোমধ্যে ক্লেইম করা লেভেল (model থাকলে) =====
    $claimed = [];
    if (class_exists(\App\Models\ReferralBonusClaim::class)) {
      try {
        $claimed = \App\Models\ReferralBonusClaim::where('user_id',auth()->id())
                   ->pluck('level_id')->all();
      } catch (\Throwable $e) { $claimed = []; }
    }
  @endphp

  <div class="wrap">
    @foreach($levels as $L)
      @php
        $t = (int)$L->target_count;                  // target
        $curr = min($level1, $t);                    // progress
        $unlocked = $level1 >= $t;                   // reached?
        $claimedAlready = in_array($L->id, $claimed);
        $pct = $t ? min(100, round(($curr/$t)*100)) : 0;
      @endphp

      <div class="card">
        <div class="right">
          {{ $unlocked ? ($claimedAlready ? 'ক্যাশ আউট সম্পন্ন' : 'আনলক হয়েছে') : 'সম্পূর্ণ হয়নি' }}
        </div>

        {{-- Stamp: Unlocked & Claimed -> "Done", Unlocked & Not Claimed -> "Claim" --}}
        @if($unlocked)
          <div class="stamp">{{ $claimedAlready ? 'Done' : 'Claim' }}</div>
        @endif

        <h4 class="title">{{ $t }} জন বৈধ সদস্যকে আমন্ত্রণ</h4>
        <div class="reward">ক্যাশ পুরস্কার: {{ number_format($L->reward_amount,2) }}</div>

        @if(!$unlocked)
          <div class="prog">
            <div class="bar"><div class="fill" style="width: {{ $pct }}%"></div></div>
            <div class="num">{{ $curr }} / {{ $t }}</div>
          </div>
        @else
          @if(!$claimedAlready)
            {{-- ✅ Claim: user.bonus.claim (POST) --}}
            <form method="POST" action="{{ route('user.bonus.claim',$L->id) }}">
              @csrf
              <button type="submit" class="claim-btn">ক্যাশ আউট নিন</button>
            </form>
          @endif
        @endif
      </div>
    @endforeach
  </div>

</body>
</html>
