<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>ব্যাংক কার্ড যুক্ত করুন</title>

  <link rel="stylesheet" href="{{ asset('public/bp/main.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/card.css') }}">
  <link rel="stylesheet" href="{{ asset('public/bp/loading.css') }}">

  <style>
    :root{
      --green:#1f8b4c; --ink:#111827; --muted:#6b7280;
      --line:#ececec; --bg:#f7f7f7; --card:#ffffff;
    }
    *{box-sizing:border-box}
    body{ margin:0; background:var(--bg); color:var(--ink);
      font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif; }
    .page-wrap{ padding-bottom:92px; }

    /* Header */
    .headerid{ position:sticky; top:0; z-index:5; background:#fff; border-bottom:1px solid var(--line); }
    .headergrid{ display:grid; grid-template-columns:44px 1fr 60px; align-items:center; padding:10px 12px; }
    .back{ width:24px;height:24px; display:flex; align-items:center; justify-content:center; cursor:pointer; }
    .title{ text-align:center; font-weight:800; }
    .header-actions{ display:flex; gap:10px; justify-content:flex-end; }
    .header-actions img{ width:22px; height:22px; }

    /* Cards / form */
    .container{ padding:12px; }
    .card{ background:var(--card); border:1px solid var(--line); border-radius:16px; box-shadow:0 1px 0 rgba(0,0,0,.03); }
    .pad{ padding:14px; }

    .form-head{ display:flex; align-items:center; gap:10px; margin-bottom:8px; }
    .form-ico{ width:40px;height:40px; border-radius:12px; background:#e8f5ee; border:1px solid rgba(31,139,76,.35); display:flex; align-items:center; justify-content:center; }
    .form-ico img{ width:22px; height:22px; object-fit:contain; }
    .form-title{ font-weight:900; color:#0f172a; }
    .form-sub{ color:#64748b; font-weight:700; font-size:12px; margin-top:2px; }

    .group{ margin-top:12px; }
    .label{ display:block; font-weight:800; margin-bottom:6px; color:#334155; }
    .input{ width:100%; height:44px; border:1px solid #e5e7eb; border-radius:12px; background:#fafafa; padding:0 12px; outline:0; font-weight:700; }
    .selectwrap{ position:relative; border:1px solid #e5e7eb; border-radius:12px; background:#fafafa; }
    .selectwrap select{ width:100%; height:44px; border:none; outline:0; background:transparent; padding:0 36px 0 12px; font-weight:800; color:#0f172a; }
    .selectwrap .arrow{ position:absolute; right:10px; top:50%; transform:translateY(-50%); width:18px; height:18px; opacity:.7; }
    .hint{ margin-top:8px; color:var(--muted); font-size:12px; font-weight:700; }

    .submit{ width:100%; border:none; border-radius:12px; padding:12px; margin-top:14px; background:var(--green); color:#fff; font-weight:900; cursor:pointer; box-shadow:0 10px 18px rgba(31,139,76,.18); }

    .foot{ text-align:center; margin-top:14px; color:#94a3b8; font-weight:700; }
    .foot img{ width:120px; opacity:.9; display:block; margin:10px auto 0; }

    /* Bottom tabbar */
    .tabbar{ position:fixed; left:0; right:0; bottom:0; background:#ffffff; border-top:1px solid var(--line); padding:8px 6px; z-index:999; }
    .tabs{ display:grid; grid-template-columns:repeat(5,1fr); gap:4px; text-align:center; }
    .tab a{ display:flex; flex-direction:column; gap:4px; align-items:center; font-size:12px; color:#64748b; text-decoration:none; }
    .tab .ico{ width:26px; height:26px; display:flex; align-items:center; justify-content:center; }
    .tab .ico img{ width:100%; height:100%; object-fit:contain; filter:saturate(1) contrast(1.05); }
    .tab.active a{ color:var(--green); font-weight:800; }
    .tab.active .ico img{ filter:saturate(1.2) contrast(1.1); }
    .tab a:active{ transform:translateY(1px); }
  </style>
</head>
<body>
@php
  $user = auth()->user();

  // ---- SAFE URLs (namespace ছাড়াই Facade alias ব্যবহৃত) ----
  $homeUrl     = Route::has('user.home')     ? route('user.home')     : url('/');
  $productsUrl = Route::has('user.products') ? route('user.products')
                : (Route::has('user.home')   ? route('user.home').'#productsSection' : url('/#productsSection'));
  $gamesUrl    = Route::has('user.games')    ? route('user.games')    : url('spin');
  $inviteUrl   = Route::has('user.invite')   ? route('user.invite')   : url('invite');
  $mineUrl     = Route::has('user.profile')  ? route('user.profile')  : url('mine');
@endphp

@include('app.layout.loading')

<div class="page-wrap">
  <!-- Header -->
  <div class="headerid">
    <div class="headergrid">
      <div class="back" onclick="history.back()">
        <img src="{{ asset('public/bp/img/back.png') }}" alt="ফিরে যান">
      </div>
      <div class="title">ব্যাংক কার্ড যুক্ত করুন</div>
      <div class="header-actions">
        <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/kf.png') }}" alt="সহায়তা"></a>
        <a href="{{ \App\Models\Setting::first()->telegram }}"><img src="{{ asset('public/bp/img/share.png') }}" alt="শেয়ার"></a>
      </div>
    </div>
  </div>

  <!-- Form -->
  <div class="container">
    <form action="{{ route('user.bank_setup_confirm') }}" method="post" class="card pad">@csrf
      <input type="hidden" id="TOKEN" value="d909f2518cdb7cf237f00a3fd4837817">

      <div class="form-head">
        <div class="form-ico"><img src="{{ asset('public/bp/img/wallet.png') }}" alt=""></div>
        <div>
          <div class="form-title">অ্যাকাউন্ট তথ্য</div>
          <div class="form-sub">আপনার ব্যাংক অ্যাকাউন্টের সঠিক তথ্য দিন</div>
        </div>
      </div>

      <div class="group">
        <label class="label">ব্যাংক অ্যাকাউন্ট নম্বর</label>
        <input class="input check_number_func_1" type="text" beforeval=""
               name="gateway_address" value="{{ $user->gateway_address }}"
               placeholder="আপনার ব্যাংক অ্যাকাউন্ট নম্বর লিখুন">
        <div class="hint">উদাহরণ: ১২৩৪৫৬৭৮৯০</div>
      </div>

      <div class="group">
        <label class="label">অ্যাকাউন্ট ধারকের নাম</label>
        <input class="input" type="text" name="realname" value="{{ $user->realname }}" placeholder="অ্যাকাউন্ট ধারকের পূর্ণ নাম লিখুন">
      </div>

      <div class="group">
        <label class="label">ব্যাংকের নাম</label>
        <div class="selectwrap">
          <select name="gateway_method" id="gateway_method">
            @foreach(\App\Models\BankList::where('status', '1')->get() as $elemenet)
              <option value="{{ $elemenet->bank_code }}" @if($user->gateway_method == $elemenet->bank_code) selected @endif>
                {{ $elemenet->name }}
              </option>
            @endforeach
          </select>
          <img class="arrow" src="{{ asset('public/bp/img/select.png') }}" alt="">
        </div>
      </div>

      <button type="submit" class="submit">সাবমিট করুন</button>

      <div class="foot">
        Auto Earn BD Copyright © 2025
        <img src="{{ asset('public/bp/img/copyright.png') }}" alt="">
      </div>
    </form>
  </div>
</div>

@include('alert-message')

<!-- Bottom Tabbar (SAFE) -->
<nav class="tabbar">
  <div class="tabs">
    <div class="tab" data-tab="home">
      <a href="{{ $homeUrl }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/home.png') }}" alt="হোম" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>হোম</span>
      </a>
    </div>

    <div class="tab" data-tab="products">
      <a href="{{ $productsUrl }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/products.png') }}" alt="পণ্য" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>পণ্য</span>
      </a>
    </div>

    <div class="tab" data-tab="spin">
      <a href="{{ $gamesUrl }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/game.png') }}" alt="খেলা" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>খেলা</span>
      </a>
    </div>

    <div class="tab" data-tab="invite">
      <a href="{{ $inviteUrl }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/share.png') }}" alt="শেয়ার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>শেয়ার</span>
      </a>
    </div>

    <div class="tab" data-tab="mine">
      <a href="{{ $mineUrl }}">
        <div class="ico"><img src="{{ asset('public/bp/icons/me.png') }}" alt="আমার" onerror="this.src='{{ asset('public/bp/img/logo.png') }}'"></div>
        <span>আমার</span>
      </a>
    </div>
  </div>
</nav>

<script>
  // ট্যাববারে 'আমার' ট্যাব ডিফল্ট অ্যাক্টিভ (এই পেজ "প্রোফাইল/আমার" এর অংশ)
  (function(){
    const mine = document.querySelector('.tabbar .tab[data-tab="mine"]');
    if(mine){ mine.classList.add('active'); }
  })();
</script>
</body>
</html>
