<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>লগইন</title>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body { font-family: 'Roboto', sans-serif; }
    /* সবুজ টোনে ইউনিক কালারফুল (মাল্টি-গ্রিন) ব্যাকগ্রাউন্ড */
    .green-gradient-bg {
      background:
        radial-gradient(1200px 600px at -10% -10%, #a7f3d0 0%, rgba(167,243,208,0) 60%),
        radial-gradient(900px 500px at 110% 20%, #bbf7d0 0%, rgba(187,247,208,0) 60%),
        radial-gradient(800px 500px at 30% 120%, #86efac 0%, rgba(134,239,172,0) 60%),
        linear-gradient(180deg, #ecfdf5 0%, #F0F8F6 30%, #e8f7ee 100%);
    }
    /* ব্যানার—কোনো লেখা নেই, কাস্টম সবুজ শেপ */
    .banner-wrap {
      background: linear-gradient(135deg, #d1fae5, #a7f3d0);
    }
  </style>
</head>
<body class="green-gradient-bg flex items-center justify-center min-h-screen">
  <div class="w-[360px] bg-white rounded-lg shadow-md">
    <form action="{{url('login')}}" method="post">
      @csrf

<!-- নতুন ইউনিক ব্যানার (ইমেজ নয়, খালি SVG শেপ + গ্রেডিয়েন্ট; কোনো টেক্সট নেই) -->
<!-- নতুন ব্যানার: সবুজ শ্যামল গাছপালা (SVG, কোনো লেখা নেই) -->
<div class="relative rounded-t-lg overflow-hidden bg-white">
  <svg viewBox="0 0 1440 240" class="w-full h-[200px] block" preserveAspectRatio="none" aria-hidden="true">
    <defs>
      <!-- ব্যাকগ্রাউন্ড গ্রেডিয়েন্ট: সাদা→হালকা সবুজ -->
      <linearGradient id="bg" x1="0" y1="0" x2="0" y2="1">
        <stop offset="0%" stop-color="#FFFFFF"/>
        <stop offset="100%" stop-color="#ECFDF5"/>
      </linearGradient>
      <!-- সবুজ টোন -->
      <linearGradient id="leaf1" x1="0" y1="0" x2="1" y2="1">
        <stop offset="0%" stop-color="#86EFAC"/>
        <stop offset="100%" stop-color="#34D399"/>
      </linearGradient>
      <linearGradient id="leaf2" x1="1" y1="0" x2="0" y2="1">
        <stop offset="0%" stop-color="#A7F3D0"/>
        <stop offset="100%" stop-color="#10B981"/>
      </linearGradient>
      <linearGradient id="hill" x1="0" y1="0" x2="1" y2="0">
        <stop offset="0%" stop-color="#D1FAE5"/>
        <stop offset="100%" stop-color="#86EFAC"/>
      </linearGradient>
      <radialGradient id="glow" cx="80%" cy="20%" r="60%">
        <stop offset="0%" stop-color="#FFFFFF" stop-opacity="0.7"/>
        <stop offset="100%" stop-color="#FFFFFF" stop-opacity="0"/>
      </radialGradient>
    </defs>

    <!-- নরম ব্যাকগ্রাউন্ড -->
    <rect width="1440" height="240" fill="url(#bg)"/>

    <!-- দূরের পাহাড়/বনভূমি সিলুয়েট -->
    <path d="M0,170 C140,150 260,180 380,165 C520,145 620,175 740,165 C900,150 1040,185 1180,170 C1300,158 1380,170 1440,165 L1440,240 L0,240 Z"
          fill="url(#hill)" opacity="0.65"/>
    <path d="M0,185 C180,165 300,195 460,182 C640,168 760,200 940,190 C1120,178 1290,200 1440,190 L1440,240 L0,240 Z"
          fill="#BBF7D0" opacity="0.85"/>

    <!-- গাছের সারি (বাম দিক) -->
    <!-- ট্রাঙ্ক -->
    <rect x="115" y="115" width="8" height="50" rx="3" fill="#059669" opacity="0.7"/>
    <!-- ক্যানোপি -->
    <circle cx="119" cy="115" r="28" fill="url(#leaf1)" />
    <ellipse cx="98" cy="125" rx="22" ry="16" fill="url(#leaf2)" opacity="0.9"/>
    <ellipse cx="142" cy="124" rx="22" ry="16" fill="url(#leaf2)" opacity="0.9"/>

    <!-- আরেকটি গাছ -->
    <rect x="200" y="120" width="9" height="56" rx="3" fill="#047857" opacity="0.75"/>
    <circle cx="204.5" cy="116" r="24" fill="url(#leaf2)"/>
    <ellipse cx="186" cy="126" rx="18" ry="13" fill="url(#leaf1)" opacity="0.9"/>
    <ellipse cx="224" cy="127" rx="18" ry="13" fill="url(#leaf1)" opacity="0.9"/>

    <!-- মাঝামাঝি গাছ -->
    <rect x="700" y="108" width="10" height="66" rx="3" fill="#065F46" opacity="0.8"/>
    <circle cx="705" cy="102" r="30" fill="url(#leaf1)"/>
    <ellipse cx="683" cy="114" rx="22" ry="15" fill="url(#leaf2)" opacity="0.95"/>
    <ellipse cx="727" cy="115" rx="22" ry="15" fill="url(#leaf2)" opacity="0.95"/>

    <!-- ডানদিকে কয়েকটি ছোট গাছ -->
    <rect x="1100" y="128" width="7" height="48" rx="3" fill="#047857" opacity="0.8"/>
    <circle cx="1103.5" cy="122" r="20" fill="url(#leaf2)"/>
    <rect x="1185" y="122" width="7" height="48" rx="3" fill="#059669" opacity="0.8"/>
    <circle cx="1188.5" cy="116" r="22" fill="url(#leaf1)"/>

    <!-- সামনের লতাপাতা/বুশ -->
    <path d="M0,200 C140,180 220,220 340,205 C470,190 580,220 740,210 C900,200 1080,230 1220,212 C1340,198 1390,208 1440,206 L1440,240 L0,240 Z"
          fill="#A7F3D0" opacity="0.95"/>

    <!-- নরম আলোর গ্লো -->
    <rect width="1440" height="240" fill="url(#glow)" opacity="0.35"/>
  </svg>
</div>


      <!-- ফর্ম সেকশন -->
      <div class="p-6">
        <form class="space-y-4">
          <!-- মোবাইল নাম্বার -->
          <div>
            <label for="mobile" class="block text-sm font-medium text-gray-700">মোবাইল নাম্বার</label>
            <div class="mt-1">
              <input type="number" name="phone" placeholder="+88 আপনার মোবাইল নাম্বার লিখুন"
                     class="w-full p-2 border border-gray-300 rounded-md text-gray-700 focus:outline-none focus:ring-2 focus:ring-[#44A329] focus:border-[#44A329]">
            </div>
          </div>

          <!-- পাসওয়ার্ড -->
          <div>
            <label for="password" class="block text-sm font-medium text-gray-700">পাসওয়ার্ড</label>
            <div class="mt-1">
              <input type="password" name="password" placeholder="পাসওয়ার্ড (≥৬ অক্ষর)"
                     class="w-full p-2 border border-gray-300 rounded-md text-gray-700 focus:outline-none focus:ring-2 focus:ring-[#44A329] focus:border-[#44A329]">
            </div>
          </div>

          <!-- সাইন আপ লিংক -->
          <div class="flex justify-between items-center text-sm">
            <span class="text-gray-600">অ্যাকাউন্ট নেই?</span>
            <a href="{{url('register')}}" class="text-[#44A329] font-medium hover:underline">রেজিস্টার করুন</a>
          </div>

          <!-- বিচ্ছিন্ন টেক্সট -->
          <div class="text-center text-xs text-gray-500">লগইন</div>

          <!-- লগইন বাটন -->
          <button type="submit" class="w-full py-2 bg-[#44A329] text-white font-medium rounded-md text-center hover:bg-[#3c9227]">
            লগইন
          </button>
        </form>
      </div>

      <!-- ফুটার -->
      <div class="mt-8 text-center">
        <img src="{{asset('public/bp/img/copyright.png')}}" alt="BP logo" class="mx-auto mb-1">
        <p class="text-xs text-gray-500">Auto Earn BD কপিরাইট © ২০২৫</p>
        <p class="text-xs text-gray-400"></p>
      </div>

      @include('alert-message')
    </form>

    @include('alert-message')
  </div>

  <meta name="csrf-token" content="{{ csrf_token() }}" />

  <script>
    function submitForLogin() {
      var phone = document.querySelector('input[name="phone"]').value;
      var password = document.querySelector('input[name="password"]').value;
      document.querySelector('.load') && (document.querySelector('.load').style.display='block');

      if (phone !== '') {
        if (password !== '') {
          var data = { phone: phone, password: password };
          fetch('{{route('login.submit')}}', {
              method: "POST",
              body: JSON.stringify(data),
              headers: {
                'Content-type': 'application/json; charset=UTF-8',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
              }
            })
            .then(response => response.json())
            .then(data => {
              document.querySelector('.load') && (document.querySelector('.load').style.display='none');
              message(data.message);
              if (data.status === true) {
                window.location.href = data.url;
              }
            }).catch(() => {
              document.querySelector('.load') && (document.querySelector('.load').style.display='none');
            });
        } else {
          message('পাসওয়ার্ড দিন');
        }
      } else {
        message('ফোন নম্বর দিন');
      }
    }
  </script>
</body>
</html>
