@extends('admin.partials.master')
@section('admin_content')
    <style>
        .card-body { background:#1a233a; }
        .text-muted { color:#fff !important; }
        h3 { color:#fff; }
    </style>

    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-xl-12 col-12 dashboard-users">
                <div class="row">
                    <div class="col-12">
                        <div class="col-sm-6 col-12 dashboard-users-danger">
                            <div class="card text-center">
                                <div class="card-content">
                                    <div class="card-body py-1">
                                        <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                            <i class="bx bx-circle font-medium-5"></i>
                                        </div>

                                        <div class="text-muted line-ellipsis">Submit Today CronJob</div>

                                        <h3 class="my-1">
                                            @php
                                                $admin = \App\Models\Admin::first();
                                                $submittedToday = $admin && $admin->salary_date == date('Y-m-d');
                                            @endphp

                                            @unless($submittedToday)
                                                <div class="alert alert-warning" style="font-size:20px;margin-bottom:15px;">
                                                    When clicked this button please wait minimum 1 minutes
                                                </div>
                                            @endunless

                                            {{-- ✅ GET লিংক নয়, POST ফর্ম --}}
                                            <form id="salaryForm" method="POST" action="{{ route('admin.salary.submit') }}">
                                                @csrf
                                                <button
                                                    type="submit"
                                                    id="salaryBtn"
                                                    class="btn btn-success"
                                                    {{ $submittedToday ? 'disabled' : '' }}
                                                >
                                                    {{ $submittedToday ? 'Already Submitted' : 'Submit CronJob' }}
                                                </button>
                                            </form>
                                        </h3>

                                        @if($submittedToday)
                                            <div class="alert alert-danger" style="font-size:20px;margin-top:15px;">
                                                Today CronJob already submitted
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div> <!-- /.col -->
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- সাবমিটের পর বাটন ডিসেবল + টেক্সট আপডেট --}}
    <script>
        (function(){
            const form = document.getElementById('salaryForm');
            const btn  = document.getElementById('salaryBtn');
            if(form && btn){
                form.addEventListener('submit', function(){
                    btn.disabled = true;
                    btn.innerText = 'Processing...';
                });
            }
        })();
    </script>
@endsection
