{{-- Simple standalone admin list view --}}
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Referral Levels</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;margin:16px}
    .top{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
    .btn{display:inline-block;background:#16a34a;color:#fff;padding:8px 12px;border-radius:8px;text-decoration:none;font-weight:800}
    .btn-sm{padding:6px 10px}
    .btn-danger{background:#dc2626}
    .btn-primary{background:#2563eb}
    .badge{padding:4px 8px;border-radius:999px;color:#fff;font-weight:800;text-decoration:none}
    .bg-success{background:#16a34a}.bg-secondary{background:#6b7280}
    table{width:100%;border-collapse:collapse}
    th,td{border:1px solid #e5e7eb;padding:8px;text-align:left}
    th{background:#f8fafc}
    .alert{padding:10px 12px;border-radius:8px;margin-bottom:10px;font-weight:800}
    .alert-success{background:#ecfdf5;border:1px solid #a7f3d0;color:#065f46}
    .alert-danger{background:#fef2f2;border:1px solid #fecaca;color:#991b1b}
    .right{text-align:right}
    .muted{color:#6b7280}
    .foot{margin-top:10px}
  </style>
</head>
<body>

  @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif
  @if(session('error'))   <div class="alert alert-danger">{{ session('error') }}</div>   @endif

  <div class="top">
    <h2 style="margin:0">Referral Levels</h2>
    <a class="btn" href="{{ route('admin.reflevel.create') }}">+ Add Level</a>
  </div>

  <table>
    <thead>
      <tr>
        <th>ID</th>
        <th>Target Count</th>
        <th>Reward Amount (৳)</th>
        <th>Status</th>
        <th>Created</th>
        <th class="right">Actions</th>
      </tr>
    </thead>
    <tbody>
      @forelse($levels as $lv)
        <tr>
          <td>{{ $lv->id }}</td>
          <td>{{ $lv->target_count }}</td>
          <td>{{ number_format($lv->reward_amount,2) }}</td>
          <td>
            <a class="badge {{ $lv->is_active ? 'bg-success' : 'bg-secondary' }}"
               href="{{ route('admin.reflevel.status', $lv->id) }}">
              {{ $lv->is_active ? 'Active' : 'Inactive' }}
            </a>
          </td>
          <td class="muted">{{ $lv->created_at?->format('Y-m-d') }}</td>
          <td class="right">
            <a class="btn btn-primary btn-sm" href="{{ route('admin.reflevel.create', $lv->id) }}">Edit</a>
            <form style="display:inline" method="POST" action="{{ route('admin.reflevel.delete', $lv->id) }}"
                  onsubmit="return confirm('Delete this level?')">
              @csrf @method('DELETE')
              <button class="btn btn-danger btn-sm" type="submit">Delete</button>
            </form>
          </td>
        </tr>
      @empty
        <tr><td colspan="6" class="muted" style="text-align:center;padding:18px">No levels found</td></tr>
      @endforelse
    </tbody>
  </table>

  <div class="foot">
    {{-- যদি আপনার paginator view সেটআপ থাকে তাহলে এটা দেখাবে --}}
    {{ $levels->links() }}
  </div>

</body>
</html>
