<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>{{ $level->id ? 'Edit Level' : 'Add Level' }}</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;margin:16px}
    .top{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
    .btn{display:inline-block;background:#2563eb;color:#fff;padding:8px 12px;border-radius:8px;text-decoration:none;font-weight:800}
    .btn-light{background:#e5e7eb;color:#111827}
    .btn-primary{background:#2563eb}
    .card{border:1px solid #e5e7eb;border-radius:10px}
    .card-head{padding:10px 12px;border-bottom:1px solid #e5e7eb;font-weight:900}
    .card-body{padding:12px}
    .form-group{margin-bottom:12px}
    label{display:block;font-weight:800;margin-bottom:6px}
    input[type=number]{width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px}
    .form-check{display:flex;align-items:center;gap:8px;margin-top:6px}
    .actions{display:flex;gap:8px;justify-content:flex-end;padding:10px 12px;border-top:1px solid #e5e7eb}
    .alert{padding:10px 12px;border-radius:8px;margin-bottom:10px;font-weight:800}
    .alert-success{background:#ecfdf5;border:1px solid #a7f3d0;color:#065f46}
    .alert-danger{background:#fef2f2;border:1px solid #fecaca;color:#991b1b}
  </style>
</head>
<body>

  @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif
  @if(session('error'))   <div class="alert alert-danger">{{ session('error') }}</div>   @endif
  @if ($errors->any())
    <div class="alert alert-danger">
      <ul style="margin:0;padding-left:18px">
        @foreach ($errors->all() as $err) <li>{{ $err }}</li> @endforeach
      </ul>
    </div>
  @endif

  <div class="top">
    <h2 style="margin:0">{{ $level->id ? 'Edit Level' : 'Add Level' }}</h2>
    <a class="btn btn-light" href="{{ route('admin.reflevel.index') }}">← Back</a>
  </div>

  <div class="card">
    <div class="card-head">Referral Level</div>
    <form method="POST" action="{{ route('admin.reflevel.insert') }}">
      @csrf
      <input type="hidden" name="id" value="{{ $level->id }}">
      <div class="card-body">
        <div class="form-group">
          <label>Target Count *</label>
          <input type="number" min="1" name="target_count" value="{{ old('target_count', $level->target_count) }}" required>
        </div>
        <div class="form-group">
          <label>Reward Amount (৳) *</label>
          <input type="number" min="0" step="0.01" name="reward_amount" value="{{ old('reward_amount', $level->reward_amount) }}" required>
        </div>
        <div class="form-group form-check">
          <input type="checkbox" id="is_active" name="is_active" value="1"
                 {{ old('is_active', $level->is_active) ? 'checked' : '' }}>
          <label for="is_active">Active</label>
        </div>
      </div>
      <div class="actions">
        <a class="btn btn-light" href="{{ route('admin.reflevel.index') }}">Cancel</a>
        <button class="btn btn-primary" type="submit">{{ $level->id ? 'Update' : 'Create' }}</button>
      </div>
    </form>
  </div>

</body>
</html>
