@extends('admin.partials.master')
@section('admin_content')
    <style>
        label {
            text-transform: unset;
        }
    </style>

    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-12">
                <form action="{{route('admin.package.insert')}}" method="POST" enctype="multipart/form-data">@csrf
                    <input type="hidden" name="id" value="{{$data ? $data->id : ''}}">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div>{{$data ? 'Update' : 'Create New'}} Package</div>
                                    <div>
                                        <a href="{{route('admin.package.index')}}" class="btn btn-primary btn-sm">
                                            <i class="bx bx-left-arrow"></i> Package List
                                        </a>
                                    </div>
                                </div>
                            </h4>
                        </div>

                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <!-- Package Name -->
                                    <div class="col-sm-6">
                                        <label for="name">Package Name</label>
                                        <input type="text" class="form-control is-valid"
                                               name="name" id="name"
                                               placeholder="Name" value="{{$data ? $data->name : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- Title -->
                                    <div class="col-sm-6">
                                        <label for="title">Title</label>
                                        <input type="text" class="form-control is-valid"
                                               name="title" id="title"
                                               placeholder="title" value="{{$data ? $data->title : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- Upload Photo -->
                                    <div class="col-sm-12 mt-2">
                                        <div class="row">
                                            <div class="col-12 col-sm-6">
                                                <fieldset class="form-group">
                                                    <label for="basicInputFile">Upload Photo
                                                        <small>{Suggestion: size 200X200(px)}</small>
                                                    </label>
                                                    <div class="custom-file">
                                                        <input type="file" name="photo"
                                                               class="custom-file-input is-valid" id="inputGroupFile01"
                                                               @if(!$data) required @endif
                                                               onchange="showPreview(event)">
                                                        <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                                                        <div class="valid-feedback">
                                                            <i class="bx bx-radio-circle"></i>
                                                            Note: Package image mandatory
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                            <div class="col-12 col-sm-6">
                                                <div class="image_preview">
                                                    <img src="{{$data ? asset(view_image($data->photo)) : asset(not_found_img())}}"
                                                         id="file-ip-1-preview" class="rounded" alt="Preview Image"
                                                         style="width: 100px;height: 100px">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Price -->
                                    <div class="col-sm-6">
                                        <label for="price">Price</label>
                                        <input type="number" class="form-control is-valid"
                                               name="price" id="price"
                                               placeholder="Price" value="{{$data ? $data->price : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- Validity -->
                                    <div class="col-sm-6">
                                        <label for="validity">Validity days</label>
                                        <input type="number" class="form-control is-valid"
                                               oninput="calculateHour(this)"
                                               name="validity" id="validity"
                                               placeholder="Validity days" value="{{$data ? $data->validity : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- Commission -->
                                    <div class="col-sm-6">
                                        <label for="commission_with_avg_amount">Commission with average amount</label>
                                        <input type="number" class="form-control is-valid"
                                               name="commission_with_avg_amount" id="commission_with_avg_amount"
                                               placeholder="Commission with average amount"
                                               value="{{$data ? $data->commission_with_avg_amount : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- ROI -->
                                    <div class="col-sm-6">
                                        <label for="ROI">ROI</label>
                                        <input type="text" class="form-control is-valid"
                                               name="ROI" id="ROI"
                                               placeholder="number" value="{{$data ? $data->ROI : ''}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <!-- ===================== -->
                                    <!-- NEW REFERRAL SYSTEM -->
                                    <!-- ===================== -->
                                    <div class="col-sm-6 mt-3">
                                        <label for="referral_enabled">Enable Referral System</label>
                                        <select name="referral_enabled" id="referral_enabled" class="form-control">
                                            <option value="0" {{ $data && $data->referral_enabled == 0 ? 'selected' : '' }}>No</option>
                                            <option value="1" {{ $data && $data->referral_enabled == 1 ? 'selected' : '' }}>Yes</option>
                                        </select>
                                        <small class="text-muted">If “Yes”, user must have required referrals to unlock this plan.</small>
                                    </div>

                                    <div class="col-sm-6 mt-3">
                                        <label for="referral_required">Referral Required (Number)</label>
                                        <input type="number" class="form-control"
                                               name="referral_required" id="referral_required"
                                               value="{{$data ? $data->referral_required : 0}}" min="0">
                                        <small class="text-muted">Enter number of referrals required to unlock this plan.</small>
                                    </div>
                                    <!-- ===================== -->
                                    <!-- END REFERRAL SYSTEM -->
                                    <!-- ===================== -->

                                    <!-- ===================== -->
                                    <!-- ✅ NEW: Limit per user -->
                                    <!-- ===================== -->
                                    <div class="col-sm-6 mt-3">
                                        <label for="max_per_user"><strong>Limit per user (times)</strong></label>
                                        <input
                                            id="max_per_user"
                                            type="number"
                                            name="max_per_user"
                                            min="0"
                                            value="{{ $data ? ($data->max_per_user ?? 0) : 0 }}"
                                            class="form-control"
                                            placeholder="0 = Unlimited"
                                        >
                                        <small class="text-muted"></small>
                                        @error('max_per_user')
                                          <div class="text-danger" style="margin-top:6px">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <!-- ===================== -->
                                    <!-- ✅ END: Limit per user -->
                                    <!-- ===================== -->

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div style="margin-top: .7rem !important">
                                        Submit Your Package Information
                                    </div>
                                    <div>
                                        <div class="form-group mb-0">
                                            <button type="submit" class="btn btn-success">
                                                <i class="bx bx-plus"></i>{{$data ? 'Update' : 'Submit'}}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </h6>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <script>
        function showPreview(event) {
            if (event.target.files.length > 0) {
                var src = URL.createObjectURL(event.target.files[0]);
                var preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }

        function calculateHour(_this) {
            document.getElementById('hours').value = _this.value * 24
        }
    </script>
@endsection
