<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('packages', function (Blueprint $table) {
            // 0/NULL = unlimited
            if (!Schema::hasColumn('packages', 'max_per_user')) {
                $table->unsignedInteger('max_per_user')->nullable()->after('ROI');
            }
        });
    }

    public function down(): void {
        Schema::table('packages', function (Blueprint $table) {
            if (Schema::hasColumn('packages', 'max_per_user')) {
                $table->dropColumn('max_per_user');
            }
        });
    }
};
