<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('referral_bonus_claims', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('level_id')->constrained('referral_levels')->cascadeOnDelete();
            $table->decimal('amount', 12, 2);
            $table->timestamp('claimed_at')->nullable();
            $table->timestamps();

            // প্রতি ইউজার একটি লেভেল একবারই ক্লেইম করতে পারবে
            $table->unique(['user_id','level_id']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('referral_bonus_claims');
    }
};
