<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('referral_levels', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('target_count');      // কতজন লেভেল-১ রেফার লাগবে
            $table->decimal('reward_amount', 12, 2);      // কত টাকা পুরস্কার
            $table->boolean('is_active')->default(true);  // অ্যাডমিন থেকে অন/অফ
            $table->timestamps();

            $table->unique(['target_count']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('referral_levels');
    }
};
