<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    /**
     * যেসব ফিল্ড mass-assign করা যাবে
     */
    protected $fillable = [
        'name',
        'title',
        'photo',
        'price',
        'validity',
        'commission_with_avg_amount',
        'ROI',
        'package_commission',
        'commission_with_avg_amount',
        'sponsor_income',
        'first_ref',
        'second_ref',
        'third_ref',
        'status',
        'is_default',
        // ✅ রেফারেল সম্পর্কিত (আগের মতোই)
        'referral_enabled',
        'referral_required',
        // ✅ নতুন: একজন ইউজার সর্বোচ্চ কয়বার কিনতে পারবে (0/NULL = unlimited)
        'max_per_user',
    ];

    /**
     * ডাটা টাইপ কাস্টিং
     */
    protected $casts = [
        'price'                       => 'float',
        'validity'                    => 'integer',
        'commission_with_avg_amount'  => 'float',
        'ROI'                         => 'float',
        'package_commission'          => 'float',
        'sponsor_income'              => 'float',
        'first_ref'                   => 'float',
        'second_ref'                  => 'float',
        'third_ref'                   => 'float',
        'referral_enabled'            => 'boolean',
        'referral_required'           => 'integer',
        // ✅ নতুন কাস্ট
        'max_per_user'                => 'integer',
    ];
}
