<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\ReferralBonusClaim;
use App\Models\ReferralLevel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BonusClaimController extends Controller
{
    public function claim(Request $request, $levelId)
    {
        $user = $request->user();

        // 1) লেভেল আছে/একটিভ কিনা
        $level = ReferralLevel::where('id', $levelId)->where('is_active', 1)->first();
        if (!$level) {
            return back()->with('error', 'Invalid level or disabled by admin.');
        }

        // 2) আগেই ক্লেইম করা হয়েছে কিনা
        $already = ReferralBonusClaim::where('user_id', $user->id)
            ->where('level_id', $level->id)
            ->exists();
        if ($already) {
            return back()->with('error', 'এই লেভেলের বোনাস আপনি আগেই নিয়েছেন।');
        }

        // 3) লেভেল-১ রেফার কাউন্ট (আপনার টেবিলের ৩টি সম্ভাব্য কলাম ধরে)
        $level1 = 0;
        try {
            if (\Schema::hasColumn('users', 'ref_by')) {
                $level1 = User::where('ref_by', $user->id)->count();
            } elseif (\Schema::hasColumn('users', 'parent_id')) {
                $level1 = User::where('parent_id', $user->id)->count();
            } elseif (\Schema::hasColumn('users', 'invited_by')) {
                $level1 = User::where('invited_by', $user->id)->count();
            }
        } catch (\Throwable $e) {
            $level1 = 0;
        }

        if ($level1 < (int) $level->target_count) {
            return back()->with('error', 'এখনও শর্ত পূরণ হয়নি। আরও রেফার করুন।');
        }

        // 4) ব্যালেন্স যোগ + ক্লেইম রেকর্ড (ট্রানজেকশন)
        DB::transaction(function () use ($user, $level) {
            // Assumption: users টেবিলে balance কলাম আছে
            $u = User::lockForUpdate()->find($user->id);
            $u->balance = ($u->balance ?? 0) + (float) $level->reward_amount;
            $u->save();

            ReferralBonusClaim::create([
                'user_id'    => $u->id,
                'level_id'   => $level->id,
                'amount'     => $level->reward_amount,
                'claimed_at' => now(),
            ]);
        });

        return back()->with('success', 'অভিনন্দন! বোনাস আপনার ওয়ালেটে যোগ হয়েছে।');
    }
}
