<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\ReferralLevel;
use Illuminate\Http\Request;

class ReferralLevelController extends Controller
{
    // List
    public function index()
    {
        $levels = ReferralLevel::orderBy('target_count')->paginate(20);
        // ⚠️ view path আপনার স্ট্রাকচার অনুসারে
        return view('admin.pages.referral_levels.index', compact('levels'));
    }

    // Create / Edit
    public function create($id = null)
    {
        $level = $id ? ReferralLevel::findOrFail($id) : new ReferralLevel([
            'is_active' => 1,
        ]);
        return view('admin.pages.referral_levels.create', compact('level'));
    }

    // Insert or Update
    public function insert_or_update(Request $request)
    {
        $id = $request->input('id');

        $data = $request->validate([
            'target_count'  => 'required|integer|min:1',
            'reward_amount' => 'required|numeric|min:0',
            'is_active'     => 'nullable|boolean',
        ]);

        $data['is_active'] = (int) ($request->boolean('is_active'));

        if ($id) {
            $level = ReferralLevel::findOrFail($id);
            $exists = ReferralLevel::where('target_count', $data['target_count'])
                ->where('id', '!=', $id)->exists();
            if ($exists) return back()->with('error', 'এই target_count আগে থেকেই আছে।')->withInput();

            $level->update($data);
            return redirect()->route('admin.reflevel.index')->with('success', 'Referral level আপডেট হয়েছে।');
        } else {
            $exists = ReferralLevel::where('target_count', $data['target_count'])->exists();
            if ($exists) return back()->with('error', 'এই target_count আগে থেকেই আছে।')->withInput();

            ReferralLevel::create($data);
            return redirect()->route('admin.reflevel.index')->with('success', 'Referral level তৈরি হয়েছে।');
        }
    }

    // Toggle Status
    public function status($id)
    {
        $level = ReferralLevel::findOrFail($id);
        $level->is_active = $level->is_active ? 0 : 1;
        $level->save();
        return back()->with('success', 'স্ট্যাটাস বদলানো হয়েছে।');
    }

    // Delete
    public function delete($id)
    {
        $level = ReferralLevel::findOrFail($id);
        $level->delete();
        return back()->with('success', 'Referral level মুছে ফেলা হয়েছে।');
    }
}
