<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PackageController extends Controller
{
    public $route = 'admin.package';

    public function index()
    {
        $packages = Package::get();
        return view('admin.pages.package.index', compact('packages'));
    }

    public function set_bonus_vip($id)
    {
        $packages = Package::get();
        foreach ($packages as $package){
            Package::where('id', $package->id)->update(['bonus_vip_id'=> null]);
        }

        $package = Package::find($id);
        $package->bonus_vip_id = $id;
        $package->update();
        return redirect()->route('admin.package.index')->with('success','Bonus vip set');
    }

    public function create($id=null)
    {
        $data = null;
        if ($id){
            $data = Package::find($id);
        }
        return view('admin.pages.package.insert', compact('data'));
    }

    public function view($id=null)
    {
        $data = Package::find($id);
        return view('admin.pages.package.view', compact('data'));
    }

    public function insert_or_update(Request $request)
    {
        // ✅ Validation (নতুন max_per_user সহ)
        $this->validate($request,[
            'name'                       => 'required',
            'title'                      => 'required',
            'price'                      => 'required|numeric',
            'validity'                   => 'required|numeric',
            'commission_with_avg_amount' => 'required|numeric',
            'ROI'                        => 'required',
            'referral_enabled'           => 'nullable|boolean',
            'referral_required'          => 'nullable|integer|min:0',
            // ✅ নতুন লিমিট ফিল্ড
            'max_per_user'               => 'nullable|integer|min:0',
        ]);

        // Editing বা Creating
        if ($request->id){
            $model = Package::findOrFail($request->id);
        } else {
            $model = new Package();
        }

        // ছবি আপলোড (আগের মতোই)
        $path = uploadImage(false ,$request, 'photo', 'upload/package/', 200, 200 ,$model->photo);
        $model->photo = $path ?? $model->photo;

        // বেস ফিল্ডগুলো
        $model->name                        = $request->name;
        $model->title                       = $request->title;
        $model->price                       = $request->price;
        $model->validity                    = $request->validity;
        $model->commission_with_avg_amount  = $request->commission_with_avg_amount;
        $model->ROI                         = $request->ROI;

        // ✅ Referral ফিল্ড
        $model->referral_enabled  = $request->boolean('referral_enabled');               // true/false
        $model->referral_required = (int) $request->input('referral_required', 0);       // number

        // ✅ নতুন: প্রতি ইউজারের জন্য লিমিট
        // 0 = আনলিমিটেড, >0 হলে ঐ সংখ্যার বেশি কিনতে পারবে না
        $model->max_per_user      = (int) $request->input('max_per_user', 0);

        // enabled না হলে সংখ্যা 0 (stale value এড়াতে)
        if (!$model->referral_enabled) {
            $model->referral_required = 0;
        }

        $model->save();

        return redirect()
            ->route($this->route.'.index')
            ->with('success', $request->id ? 'Package Updated Successful.' : 'Package Created Successful.');
    }

    public function delete($id)
    {
        $model = Package::find($id);
        deleteImage($model->photo);
        $model->delete();
        return redirect()->route($this->route.'.index')->with('success','Item Deleted Successful.');
    }
}
