<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth; 
use App\Models\User; 
use App\Models\Deposit; 

class PaymentController extends Controller
{
    public function showPaymentPage()
    {
        return view('deposit'); 
    }

    public function createPayment(Request $request)
    {
        $response = Http::withHeaders([
            'app-key' => config('app.gateway.app_key'),
            'secret-key' => config('app.gateway.secret_key'),
            'host-name' => config('app.gateway.host_name'),
        ])->asForm()->post(config('app.gateway.create_url'), [
            'cus_name' => $request->customer_name,
            'cus_email' => $request->customer_email,
            'amount' => $request->amount,
            'success_url' => route('payment.success'),
            'cancel_url' => route('payment.cancel'),
        ]);

        $responseData = $response->json();

       
        return $response->body();
    }

    public function paymentSuccess(Request $request)
    {
        $transactionId = $request->input('transactionId');

        $verifyResponse = Http::withHeaders([
            'app-key' => config('app.gateway.app_key'),
            'secret-key' => config('app.gateway.secret_key'),
            'host-name' => config('app.gateway.host_name'),
        ])->asForm()->post(config('app.gateway.verify_url'), [
            'transaction_id' => $transactionId,
        ]);

        $verificationDetails = $verifyResponse->json();

        if (isset($verificationDetails['status']) && $verificationDetails['status'] == '1') {
            
            $user = Auth::user();

            if ($user) {
                $amount = $verificationDetails['amount'];

                $user->deposit_balance += $amount;
                
                $user->save();

               
                $deposit = new Deposit();
                $deposit->user_id = $user->id;
                $deposit->method_name = 'Online Gateway'; 
                $deposit->order_id = rand(00000,99999); 
                $deposit->transaction_id = $transactionId; 
                $deposit->amount = $amount;
                $deposit->final_amount = $amount;
                $deposit->date = date('d-m-Y H:i:s'); 
                $deposit->status = 'approved';
                $deposit->save();
                
                return redirect('/home')->with('success', "পেমেন্ট সফল হয়েছে! {$amount} BDT আপনার ব্যালেন্সে যোগ করা হয়েছে।");
            } else {
                return redirect('/login')->with('error', 'ব্যবহারকারী লগইন করা নেই। ব্যালেন্স যোগ করা সম্ভব হয়নি।');
            }

        } else {
            
            return redirect('/deposit')->with('error', "পেমেন্ট ভেরিফিকেশন ব্যর্থ হয়েছে।");
        }
    }

    public function paymentCancel(Request $request)
    {
        $transactionId = $request->input('transactionId');
        
        return redirect('/deposit')->with('error', "পেমেন্ট বাতিল করা হয়েছে। Transaction ID: " . $transactionId);
    }
}