<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule): void
    {
        // প্রতি মিনিটে ডেইলি ইনকাম ক্রেডিট হবে
        $schedule->command('income:credit-daily')
            ->withoutOverlapping()   // আগের রান শেষ না হলে নতুনটা শুরু করবে না
            ->runInBackground()      // ব্যাকগ্রাউন্ডে চালাবে
            ->everyMinute();         // প্রতি মিনিটে
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands(): void
    {
        // app/Console/Commands ফোল্ডারের কমান্ডগুলো লোড হবে
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
